/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.regex.Pattern;

import net.morilib.awk.expr.AwkCastException;

public class AwkRegex implements AwkValue {

	private Pattern regex;

	private AwkRegex(String regex) {
		this.regex = Pattern.compile(regex);
	}

	public static AwkRegex valueOf(String regex) {
		return new AwkRegex(regex);
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return true;
	}

	public boolean isFunction() {
		return false;
	}

	public AwkValue putArray(AwkValue k, AwkValue v) {
		throw new AwkCastException();
	}

	public AwkValue referArray(AwkValue v) {
		throw new AwkCastException();
	}

	public AwkValue deleteArray(AwkValue v) {
		throw new AwkCastException();
	}

	public Collection<AwkValue> values() {
		throw new AwkCastException();
	}

	public boolean toBoolean() {
		return false;
	}

	public double toFloat() {
		throw new AwkCastException();
	}

	public BigInteger toInteger() {
		throw new AwkCastException();
	}

	public Number toReal() {
		throw new AwkCastException();
	}

	public Pattern toRegex() {
		return regex;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return regex;
	}

	public int compareTo(AwkValue o) {
		if(o instanceof AwkUndefined) {
			return 1;
		} else {
			return regex.pattern().compareTo(o.toString());
		}
	}

}
