/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkBuiltInTest extends AwkTestCase {

	public void testLength() {
		eqi("length(\"a\");", 1);
	}

	public void testIndex() {
		eqi("index(\"banana\", \"an\");", 2);
		eqi("index(\"banana\", \"zz\");", 0);
	}

	public void testSplit() {
		eqi("{ split(\"aaa  bbb cc\", a, \" \"); 1; }", 1);
		eqs("a[1];", "aaa");
		eqs("a[2];", "bbb");
		eqs("a[3];", "cc");
		eqi("{ split(\"aaa  bbb cc\", a[1], \" \"); 1; }", 1);
		eqs("a[1,1];", "aaa");
		eqs("a[1,2];", "bbb");
		eqs("a[1,3];", "cc");
	}

}
