/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import net.morilib.awk.code.AwkExecutable;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class AwkProgramTest extends AwkTestCase {

	public void testProgram0001() {
		AwkExecutable e = pre("{ print; }");

		e.execute(ns0, fs0, "aaaa");
		eot("aaaa");
	}

	public void testProgram0002() {
		AwkExecutable e = pre("{ print $1, $2; }");

		e.execute(ns0, fs0, "765 876 961");
		eot("765 876");
	}

	public void testProgram0011() {
		AwkExecutable e = pre("/a+/ { print; }");

		e.execute(ns0, fs0, "aaaa");
		e.execute(ns0, fs0, "bbbb");
		e.execute(ns0, fs0, "abba");
		eot("aaaa");
		eot("abba");
	}

	public void testProgram0012() {
		AwkExecutable e = pre("/a+/, /b+/ { print; }");

		e.execute(ns0, fs0, "bbbb");
		e.execute(ns0, fs0, "aaaa");
		e.execute(ns0, fs0, "dddd");
		e.execute(ns0, fs0, "cccc");
		e.execute(ns0, fs0, "abba");
		e.execute(ns0, fs0, "abba");
		eot("aaaa");
		eot("dddd");
		eot("cccc");
		eot("abba");
		eot();
	}

	public void testProgram0021() {
		AwkExecutable e = pre("" +
				"function aaa() { print; }" +
				"{ aaa(); }");

		e.execute(ns0, fs0, "aaaa");
		eot("aaaa");
	}

	public void testProgram0022() {
		AwkExecutable e = pre("" +
				"function aaa(aaa) { print aaa; }" +
				"{ aaa($0); aaa($0); }");

		e.execute(ns0, fs0, "aaaa");
		eot("aaaa");
		eot("aaaa");
	}

	public void testProgram0023() {
		AwkExecutable e = pre("" +
				"function aaa(a, b) { print a, b; }" +
				"{ aaa($1, $2); }");

		e.execute(ns0, fs0, "aaa bbb");
		eot("aaa bbb");
	}

	public void testProgram0024() {
		AwkExecutable e = pre("" +
				"function aaa() { print a++; }" +
				"{ aaa(); print a; }");

		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		eot("0");
		eot("1");
		eot("1");
		eot("2");
		eot("2");
		eot("3");
	}

	public void testProgram0031() {
		AwkExecutable e = pre("" +
				"BEGIN { a = 1; }\n" +
				"{ print a; }\n" +
				"END { print 2; }");

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, "aaaa");
		e.executeEnd(ns0, fs0);
		eot("1");
		eot("2");
	}

}
