/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.AwkSQLException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkSQLConnection;
import net.morilib.awk.value.AwkValue;

public class UtilSqlconnection extends AwkFunction {

	protected UtilSqlconnection() {
		super("sqlconnection", null);
	}

	private String tos(AwkArray a, String s) {
		AwkValue v = a.referArray(s);

		return v.isEmpty() ? null : v.toString();
	}

	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		String url, usr, pwd;
		Connection c;
		AwkArray a;

		if(args.size() < 1) {
			throw new AwkRuntimeException("too few argument");
		} else if(args.get(0) instanceof AwkArray) {
			a = (AwkArray)args.get(0);
			try {
//				Class.forName(a.referArray("driver").toString());
				url = tos(a, "url");
				usr = tos(a, "user");
				pwd = tos(a, "password");
				c = DriverManager.getConnection(url, usr, pwd);
				return new AwkSQLConnection(c);
//			} catch (ClassNotFoundException e) {
//				throw new AwkRuntimeException(e);
			} catch (SQLException e) {
				throw new AwkSQLException(e);
			}
		} else {
			throw new AwkRuntimeException();
		}
	}

}
