/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

/**
 * 範囲のあるパターンの中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkRangedPattern implements AwkPattern {

	//
	private AwkPattern begin, end;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param begin 行開始パターン
	 * @param end   行終了パターン
	 */
	public AwkRangedPattern(AwkPattern begin, AwkPattern end) {
		this.begin = begin;
		this.end   = end;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isBegin()
	 */
	public boolean isBegin() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isEnd()
	 */
	public boolean isEnd() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#match(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, java.lang.String, net.morilib.awk.pattern.AwkMatchState)
	 */
	public AwkMatchState match(AwkNamespace ns, AwkFiles fs,
			String s, AwkMatchState stat) {
		switch(stat) {
		case NO_MATCH:
			if(begin.match(ns, fs, s, stat).isNotMatched()) {
				return AwkMatchState.NO_MATCH;
			} else if(end.match(ns, fs, s, stat).isNotMatched()) {
				return AwkMatchState.IS_MATCHING;
			} else {
				return AwkMatchState.MATCHED;
			}
		case IS_MATCHING:
			if(end.match(ns, fs, s, stat).isNotMatched()) {
				return AwkMatchState.IS_MATCHING;
			} else {
				return AwkMatchState.MATCHED;
			}
		case MATCHED:  return AwkMatchState.MATCHED;
		default:  throw new RuntimeException();
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isRanged()
	 */
	public boolean isRanged() {
		return true;
	}

}
