/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.stat.dist;

/**
 * 離散確率分布を表すインターフェースです。
 *
 * @author MORIGUCHI, Yuichiro 2012/02/14
 */
public interface DiscreteDistribution extends Distribution {

	/**
	 * 確率分布を求めます。
	 * 
	 * @param n 値
	 * @return 確率分布
	 */
	public double f(int n);

	/**
	 * 値が台にあるかを調べます。
	 * 
	 * @param n 値
	 * @return 台にあるときtrue
	 */
	public boolean isInSupport(int n);

	/**
	 * 台の下限を求めます。
	 * 
	 * @return 下限
	 */
	public int supportMinimum();

	/**
	 * 台の上限を返します。
	 * 
	 * @return 上限
	 */
	public int supportMaximum();

	/**
	 * 確率点を求めます。
	 * 
	 * @param p 確率
	 * @return 確率点
	 */
	public int invCdf(double p);

}
