/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.statement;

import net.morilib.awk.AwkBreakException;
import net.morilib.awk.AwkContinueException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * do-while文の中間表現です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public class AwkDoWhile extends AwkExpression {

	private AwkExpression cond, stmt;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param cond 条件文の中間表現
	 * @param stmt 実行文の中間表現
	 */
	public AwkDoWhile(AwkExpression cond, AwkExpression stmt) {
		this.cond = cond;
		this.stmt = stmt;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue v = AwkUndefined.UNDEF;

		try {
			do {
				try {
					v = stmt.eval(ns, o);
				} catch(AwkContinueException e) {}
			} while(cond.eval(ns, o).toBoolean(ns));
		} catch(AwkBreakException e) {}
		return v;
	}

	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object r = new Object(), l = new Object(), c = new Object();

		b.addLabel(l);
		stmt.compileInternally(b, r, c);
		b.addLabel(c);
		b.add(cond);
		b.addJmpNZ(l);
		b.addLabel(r);
	}

}
