/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkComplex extends AwkValue {

	//
	private double real, imag;

	//
	private AwkComplex(double real, double imag) {
		this.real = real;
		this.imag = imag;
	}

	/**
	 * 
	 * @param real
	 * @param imag
	 * @return
	 */
	public static AwkValue valueOf(double real, double imag) {
		if(Double.isNaN(real) || Double.isNaN(imag)) {
			return AwkFloat.valueOf(Double.NaN);
		} else if(imag == 0) {
			return AwkFloat.valueOf(real);
		} else {
			return new AwkComplex(real, imag);
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toFloat()
	 */
	public double toFloat() {
		return real;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toImaginary()
	 */
	public double toImaginary() {
		return imag;
	}

	public AwkValue toNumber() {
		return this;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#isComplex()
	 */
	public boolean isComplex() {
		return true;
	}

	public String toString(AwkNamespace ns) {
		if(imag > 0) {
			return real + "+" + imag + "i";
		} else {
			return real + "" + imag + "i";
		}
	}

	public boolean toBoolean(AwkNamespace ns) {
		return true;
	}

	public Object toObject() {
		return new double[] { real, imag };
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	public boolean isPositiveValue() {
		return false;
	}

	public boolean isZeroValue() {
		return false;
	}

	public boolean isNegativeValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public boolean isNumber() {
		return true;
	}

	public int compareTo(AwkValue v, AwkNamespace ns) {
		throw new AwkCastException(this + " is not comparable");
	}

}
