/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShRmdir implements ShProcess {

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		boolean parent = false;
		int k = 1, r = 0;
		ShFile f;
		String x;

		if(args[k].equals("-p") || args[k].equals("--parent")) {
			parent = true;
			k++;
		}

		for(int i = k; i < args.length; i++) {
			if(args[i].length() == 0) {
				err.println("rmdir: an empty filename is forbidden.");
				r = 2;
			} else if(!(f = fs.getFile(args[i])).isDirectory()) {
				err.print("rmdir: ");
				err.print(args[i]);
				err.println(" is not a directory.");
				r = 2;
			} else if(!parent) {
				if(!f.rmdir()) {
					err.print("rmdir: ");
					err.print(args[i]);
					err.println(" is not empty");
					r = 2;
				}
			} else if(args[i].charAt(0) == '/') {
				err.print("rmdir: absolute path with -p option ");
				err.println("is forbidden.");
				r = 2;
			} else {
				x = args[i];
				while(x.length() > 0) {
					x = x.replaceFirst("/+$", "");
					if(!(f = fs.getFile(x)).isDirectory()) {
						err.print("rmdir: ");
						err.print(args[i]);
						err.println(" is not a directory.");
						r = 2;
					} else if(!f.rmdir()) {
						err.print("rmdir: ");
						err.print(x);
						err.println(" is not empty");
						r = 2;
						break;
					}
					x = x.replaceFirst("[^/]+$", "");
				}
			}
		}
		return r;
	}

}
