/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkStatementTest extends AwkTestCase {

	public void testError001() {
		erz("aaaa(1)");
	}

	public void testIf() {
		eqi("if(1 == 1) 1; else 2;", 1);
		eqi("if(1 != 1) 1; else 2;", 2);
		eqi("if(1 == 1) 1;", 1);
		eqi("if(1 != 1) 1; else if(2 == 2) 2; else 3;", 2);
	}

	public void testBlock() {
		eqi("{ a = 1; b = 2; }", 2);
		eqz("a", 1);  eqz("b", 2);
		eqi("{ a = 1\n b = 2\n}", 2);
		eqz("a", 1);  eqz("b", 2);
		eqi("{ a = 1;  }", 1);  eqz("a", 1);
		eqi("{ a = 1\n }", 1);  eqz("a", 1);
	}

	public void testWhile() {
		eqi("{ a = 0; b = 0; }", 0);
		exe("while(a++ < 10)  b += a;");
		eqz("a", 11);  eqz("b", 55);
		eqi("{ a = 0; b = 0; c = 1; }", 1);
		exe("while(a++ < 5)\n{ b += a\n c *= a; }");
		eqz("a", 6);  eqz("b", 15);  eqz("c", 120);
	}

	public void testDoWhile() {
		eqi("{ a = 1; b = 0; }", 0);
		exe("do { b += a++; } while(a < 10);");
		eqz("a", 10);  eqz("b", 45);
		eqi("{ a = 0; b = 0; c = 1; }", 1);
		exe("do {\n a++\n b += a\n c *= a\n } while(a < 5)");
		eqz("a", 5);  eqz("b", 15);  eqz("c", 120);
	}

	public void testFor() {
		exe("for(a = 1; a < 10; a++)  b += a;");
		eqz("a", 10);  eqz("b", 45);
		exe("for(a = 1; a < 10; a++)\nb += a;");
		eqz("a", 10);  eqz("b", 90);
		exe("for(a = 1, b = 0, c = 1; a < 5; a++) { c *= a; b += a; }");
		eqz("a", 5);  eqz("b", 10);  eqz("c", 24);
		eqi("{ a = 0; b = 0; }", 0);
		exe("for(; a++ < 10;)  b += a;");
		eqz("a", 11);  eqz("b", 55);
		eqi("{ a = 1; b = 0; }", 0);
		exe("for(; a < 10; a++)  b += a;");
		eqz("a", 10);  eqz("b", 45);
	}

	public void testBreak() {
		exe("for(a = 1, b = 0;; a++) { if(a >= 10) break; b += a; }");
		eqz("a", 10);  eqz("b", 45);
	}

	public void testContinue() {
		exe("for(a = 1, b = 0;; a++) {\n"
				+ "if(a >= 10) break; else if(a >= 5) continue; b += a; }");
		eqz("a", 10);  eqz("b", 10);
	}

	public void testNop() {
		exe("for(a = 1; a < 10; a++);");
		eqz("a", 10);
		eqi(";\n\n;", 0);
		exe("for(a = 1; a < 10; a++)\n    ;");
		eqz("a", 10);
	}

}
