package net.morilib.sh;

import java.io.IOException;

import net.morilib.sh.testcmd.ShTestParser;
import junit.framework.TestCase;

public class ShTestTest extends TestCase {

	void eqs(int r, String... args) {
		try {
			assertEquals(r, ShTestParser.getDefault().main(
					new ShRootShellEnvironment(new ShRootEnvStub()),
					new ShFileSystemStub(),
					System.in,
					System.out,
					System.err,
					args));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void testTest001() {
		eqs(0, "test", "aaa");
		eqs(1, "test", "");
	}

	public void testTest002() {
		eqs(0, "test", "-n", "aaa");
		eqs(0, "test", "-z", "");
	}

	public void testTest003() {
		eqs(1, "test", "-n", "");
		eqs(1, "test", "-z", "aaa");
	}

	public void testTest004() {
		eqs(0, "test", "-a", "file");
		eqs(0, "test", "-d", "file");
		eqs(0, "test", "-e", "file");
		eqs(0, "test", "-f", "file");
		eqs(0, "test", "-r", "file");
		eqs(0, "test", "-w", "file");
		eqs(0, "test", "-x", "ritsuko");
		eqs(0, "test", "-s", "nonzero");
	}

	public void testTest005() {
		eqs(1, "test", "-a", "notexist");
		eqs(1, "test", "-d", "notdirectory");
		eqs(1, "test", "-e", "notexist");
		eqs(1, "test", "-f", "notfile");
		eqs(1, "test", "-r", "notreadable");
		eqs(1, "test", "-w", "notwritable");
		eqs(1, "test", "-x", "file");
		eqs(1, "test", "-s", "zero");
	}

	public void testTest006() {
		eqs(0, "test", "13", "=", "13");
		eqs(1, "test", "13", "!=", "13");
		eqs(1, "test", "13", "<",  "13");
		eqs(0, "test", "13", "<=", "13");
		eqs(1, "test", "13", ">",  "13");
		eqs(0, "test", "13", ">=", "13");

		eqs(1, "test", "2",  "=", "13");
		eqs(0, "test", "2",  "!=", "13");
		eqs(1, "test", "2",  "<",  "13");
		eqs(1, "test", "2",  "<=", "13");
		eqs(0, "test", "2",  ">",  "13");
		eqs(0, "test", "2",  ">=", "13");

		eqs(1, "test", "13", "=", "2");
		eqs(0, "test", "13", "!=", "2");
		eqs(0, "test", "13", "<",  "2");
		eqs(0, "test", "13", "<=", "2");
		eqs(1, "test", "13", ">",  "2");
		eqs(1, "test", "13", ">=", "2");

		eqs(1, "test", "013", "=", "13");
		eqs(0, "test", "013", "!=", "13");
	}

	public void testTest007() {
		eqs(0, "test", "13", "-eq", "13");
		eqs(1, "test", "13", "-ne", "13");
		eqs(1, "test", "13", "-lt", "13");
		eqs(0, "test", "13", "-le", "13");
		eqs(1, "test", "13", "-gt", "13");
		eqs(0, "test", "13", "-ge", "13");

		eqs(1, "test", "2",  "-eq", "13");
		eqs(0, "test", "2",  "-ne", "13");
		eqs(0, "test", "2",  "-lt", "13");
		eqs(0, "test", "2",  "-le", "13");
		eqs(1, "test", "2",  "-gt", "13");
		eqs(1, "test", "2",  "-ge", "13");

		eqs(1, "test", "13", "-eq", "2");
		eqs(0, "test", "13", "-ne", "2");
		eqs(1, "test", "13", "-lt", "2");
		eqs(1, "test", "13", "-le", "2");
		eqs(0, "test", "13", "-gt", "2");
		eqs(0, "test", "13", "-ge", "2");

		eqs(0, "test", "013", "-eq", "13");
		eqs(1, "test", "013", "-ne", "13");
	}

	public void testTest008() {
		eqs(0, "test", "2", "-nt", "1");
		eqs(1, "test", "2", "-nt", "2");
		eqs(1, "test", "2", "-nt", "3");

		eqs(1, "test", "2", "-ot", "1");
		eqs(1, "test", "2", "-ot", "2");
		eqs(0, "test", "2", "-ot", "3");
	}

	public void testTest009() {
		eqs(0, "test", "aaa", "-a", "bbb");
		eqs(1, "test", "aaa", "-a", "");
		eqs(1, "test", "", "-a", "bbb");
		eqs(1, "test", "", "-a", "");

		eqs(0, "test", "-z", "", "-a", "-z", "");
		eqs(1, "test", "-z", "", "-a", "-z", "aaa");
		eqs(1, "test", "-z", "aaa", "-a", "-z", "");
		eqs(1, "test", "-z", "aaa", "-a", "-z", "aaa");

		eqs(0, "test", "a", "=", "a", "-a", "a", "=", "a");
		eqs(1, "test", "a", "=", "b", "-a", "a", "=", "a");
		eqs(1, "test", "a", "=", "a", "-a", "b", "=", "a");
		eqs(1, "test", "a", "=", "b", "-a", "b", "=", "a");
	}

	public void testTest010() {
		eqs(0, "test", "aaa", "-o", "bbb");
		eqs(0, "test", "aaa", "-o", "");
		eqs(0, "test", "", "-o", "bbb");
		eqs(1, "test", "", "-o", "");

		eqs(0, "test", "-z", "", "-o", "-z", "");
		eqs(0, "test", "-z", "", "-o", "-z", "aaa");
		eqs(0, "test", "-z", "aaa", "-o", "-z", "");
		eqs(1, "test", "-z", "aaa", "-o", "-z", "aaa");

		eqs(0, "test", "a", "=", "a", "-o", "a", "=", "a");
		eqs(0, "test", "a", "=", "b", "-o", "a", "=", "a");
		eqs(0, "test", "a", "=", "a", "-o", "b", "=", "a");
		eqs(1, "test", "a", "=", "b", "-o", "b", "=", "a");
	}

	public void testTest011() {
		eqs(1, "test", "!", "aaa");
		eqs(1, "test", "!", "-z", "");
		eqs(0, "test", "!", "a", "=", "b");
	}

	public void testTest012() {
		eqs(0, "test", "aaa", "-a", "", "-o", "bbb");
		eqs(0, "test", "aaa", "-a", "bbb", "-o", "bbb", "-a", "");
		eqs(0, "test", "aaa", "-a", "", "-o", "bbb");

		eqs(0, "test", "!", "", "-a", "!", "");
		eqs(1, "test", "!", "aaa", "-o", "!", "aaa");
		eqs(1, "test", "!", "", "-a", "");
		eqs(0, "test", "!", "aaa", "-o", "aaa");
		eqs(0, "test", "!", "!", "aaa");

		eqs(1, "test", "aaa", "-a", "(", "bbb", "-o", "bbb", ")", "-a", "");
		eqs(1, "test", "(", "aaa", "-a", "bbb", "-o", "bbb", ")", "-a", "");
		eqs(0, "test", "!", "(", "", "-a", "", ")");
		eqs(1, "test", "!", "(", "aaa", "-o", "aaa", ")");
	}

}
