package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

public class ShGetoptsTest extends ShCommandExecuteTest {

	void chk(String n, String arg, int ind) {
		assertEquals(n, env.find("a"));
		assertEquals(arg, env.find("OPTARG"));
		assertEquals(ind + "", env.find("OPTIND"));
	}

	public void testGetopt001() {
		env.put("1", "-a");
		env.put("#", "2");
		exe("getopts 'abc' a", 0);
		chk("a", "", 2);
		exe("getopts 'abc' a", 1);
	}

	public void testGetopt002() {
		env.put("1", "-ab");
		env.put("#", "2");
		exe("getopts 'abc' a", 0);
		chk("a", "", 1);
		exe("getopts 'abc' a", 0);
		chk("b", "", 2);
		exe("getopts 'abc' a", 1);
	}

	public void testGetopt003() {
		env.put("1", "-ab");
		env.put("2", "aaa");
		env.put("#", "3");
		exe("getopts 'ab:c' a", 0);
		chk("a", "", 2);
		exe("getopts 'ab:c' a", 0);
		chk("b", "aaa", 3);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt004() {
		env.put("1", "-ba");
		env.put("#", "2");
		exe("getopts 'ab:c' a", 0);
		chk("b", "a", 2);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt005() {
		env.put("1", "-a");
		env.put("2", "-b");
		env.put("3", "aaa");
		env.put("#", "4");
		exe("getopts 'ab:c' a", 0);
		chk("a", "", 3);
		exe("getopts 'ab:c' a", 0);
		chk("b", "aaa", 4);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt011() {
		env.put("1", "-a");
		env.put("2", "aaa");
		env.put("#", "3");
		exe("getopts 'abc' a", 0);
		chk("a", "", 2);
		exe("getopts 'abc' a", 1);
	}

	public void testGetopt012() {
		env.put("1", "-ab");
		env.put("2", "aaa");
		env.put("#", "3");
		exe("getopts 'abc' a", 0);
		chk("a", "", 1);
		exe("getopts 'abc' a", 0);
		chk("b", "", 2);
		exe("getopts 'abc' a", 1);
	}

	public void testGetopt013() {
		env.put("1", "-ab");
		env.put("2", "aaa");
		env.put("3", "bbb");
		env.put("#", "4");
		exe("getopts 'ab:c' a", 0);
		chk("a", "", 2);
		exe("getopts 'ab:c' a", 0);
		chk("b", "aaa", 3);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt014() {
		env.put("1", "-ba");
		env.put("2", "aaa");
		env.put("#", "3");
		exe("getopts 'ab:c' a", 0);
		chk("b", "a", 2);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt015() {
		env.put("1", "-a");
		env.put("2", "-b");
		env.put("3", "aaa");
		env.put("4", "bbb");
		env.put("#", "5");
		exe("getopts 'ab:c' a", 0);
		chk("a", "", 3);
		exe("getopts 'ab:c' a", 0);
		chk("b", "aaa", 4);
		exe("getopts 'ab:c' a", 1);
	}

	public void testGetopt016() {
		env.put("1", "--");
		env.put("2", "-a");
		env.put("#", "3");
		exe("getopts 'abc' a", 1);
	}

	public void testGetopt017() {
		env.put("1", "-");
		env.put("2", "-a");
		env.put("#", "3");
		exe("getopts 'abc' a", 1);
	}

}
