/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.List;

import net.morilib.awk.AwkIndexException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class AwkSubstr extends AwkFunction {

	/**
	 * 
	 */
	public AwkSubstr() {
		super("substr", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		String s;
		int i, j;

		s = args.size() < 1 ? "" : args.get(0).toString(ns);
		i = args.size() < 2 ? 1 : args.get(1).toIntExact();
		j = args.size() < 3 ?
				s.length() - i + 1 : args.get(2).toIntExact();

		if(i < 0 || i >= s.length()) {
			throw new AwkIndexException(i);
		} else if(j < 0 || i + j - 1 > s.length()) {
			throw new AwkIndexException(j);
		}
		return AwkString.valueOf(s.substring(i - 1, i + j - 1));
	}

}
