/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkInOp extends AwkExpression {

	private AwkExpression element, array;

	/**
	 * 
	 * @param element
	 * @param array
	 */
	public AwkInOp(AwkExpression element, AwkExpression array) {
		this.element = element;
		this.array   = array;
	}

	public AwkExpression getElement() {
		return element;
	}

	public AwkExpression getArray() {
		return array;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles f) {
		AwkValue a, b;

		a = array.eval(ns, f);
		b = element.eval(ns, f);
		return AwkInteger.booleanOf(a.contains(b.toString(ns)));
	}

}
