/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public abstract class AwkFunction extends AwkValue {

	/**
	 * 
	 */
	protected String name;

	/**
	 * 
	 */
	protected AwkNamespace env;

	/**
	 * 
	 * @param name
	 */
	protected AwkFunction(String name, AwkNamespace env) {
		this.name = name;
		this.env  = env;
	}

	/**
	 * 
	 * @param ns
	 * @param o
	 * @param args
	 * @return
	 */
	public abstract AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args);

	/**
	 * 
	 * @param ns
	 * @param o
	 * @param args
	 * @return
	 */
	public AwkValue init(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		throw new AwkCastException();
	}

	/**
	 * 
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * 
	 * @return
	 */
	public AwkNamespace getEnvironment() {
		return env;
	}

	public final boolean isFloat() {
		return false;
	}

	public final boolean isFunction() {
		return true;
	}

	public final boolean isInteger() {
		return false;
	}

	public final boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	@Override
	public boolean isNegativeValue() {
		return false;
	}

	@Override
	public boolean isPositiveValue() {
		return false;
	}

	@Override
	public boolean isZeroValue() {
		return false;
	}

	public final boolean isRegex() {
		return false;
	}

	public final boolean isString() {
		return false;
	}

	public Collection<AwkValue> values() {
		throw new AwkCastException();
	}

	public final boolean toBoolean() {
		return false;
	}

	public final double toFloat() {
		throw new AwkCastException();
	}

	public final BigInteger toInteger() {
		throw new AwkCastException();
	}

	public final Number toReal() {
		throw new AwkCastException();
	}

	public final Pattern toRegex() {
		throw new AwkCastException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public final Object toObject() {
		return this;
	}

	public String toString(AwkNamespace ns) {
		return "function " + getName();
	}

	public final int compareTo(AwkValue o, AwkNamespace ns) {
		if(o instanceof AwkUndefined) {
			return 1;
		} else if(o instanceof AwkFunction) {
			return 0;
		} else {
			return -1;
		}
	}

}
