// AXL3 - An XLL Library
// Wrapper class library for Microsft Excel's xll add-in which written by C++.
//
// Copyright(c) 2009-2009, yukimi_sake@users.sourceforge.jp. All rights reserved.

// Classes of cell formats.

#pragma once

namespace xl{
	class xlBorder{
		friend class xlRange;

	private:
		xlRange* m_range;
		int m_outline_style; 
		int m_left_style;
		int m_right_style;
		int m_top_style;
		int m_bottom_style;
		bool m_shade_style;
		int m_outline_color;
		int m_left_color;
		int m_right_color;
		int m_top_color;
		int m_bottom_color;

		void putRange(xlRange* range){
			m_range = range;
		}

		void set(xlRange* range){
			m_range = range;
			API.Call(xlcSelect,0, "P", m_range);
			API.Call(xlcBorder, 0, "IIIII_IIIII",
					m_outline_style, 
					m_left_style,
					m_right_style,
					m_top_style,
					m_bottom_style,
					m_outline_color,
					m_left_color,
					m_right_color,
					m_top_color,
					m_bottom_color
			);
		}

	public:
	// constructors
		xlBorder(){
			m_outline_style = 0; 
			m_left_style = 0;
			m_right_style = 0;
			m_top_style = 0;
			m_bottom_style = 0;
			m_outline_color = 0;
			m_left_color = 0;
			m_right_color = 0;
			m_top_color = 0;
			m_bottom_color = 0;
			m_range = NULL;
		}

		xlBorder(
				const int outline_style, 
				const int left_style,
				const int right_style,
				const int top_style,
				const int bottom_style,
				const int outline_color,
				const int left_color,
				const int right_color,
				const int top_color,
				const int bottom_color
		){
			m_outline_style = outline_style; 
			m_left_style = left_style;
			m_right_style = right_style;
			m_top_style = top_style;
			m_bottom_style = bottom_style;
			m_outline_color = outline_color;
			m_left_color = left_color;
			m_right_color = right_color;
			m_top_color = top_color;
			m_bottom_color = bottom_color;
			m_range = NULL;
		}

	// destructor
		//~xlBorder(){if(m_range) delete m_range;}

	// properties
		Property(int, OutlineStyle);
		Property(int, LeftStyle);
		Property(int, RightStyle);
		Property(int, TopStyle);
		Property(int, BottomStyle);
		Property(int, OutlineColor);
		Property(int, LeftColor);
		Property(int, RightColor);
		Property(int, TopColor);
		Property(int, BottomColor);
		/*
			Line Type is
			0 No border 
			1 Thin line 
			2 Medium line 
			3 Dashed line 
			4 Dotted line 
			5 Thick line 
			6 Double line 
			7 Hairline 
		*/

	// property implements
		void putOutlineStyle(const int outline_style){
			int r;
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				r = API.Call(xlcBorder, 0, "I", outline_style);
			}
			m_outline_style = outline_style;
		}

		int getLeftStyle(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 9, m_range);
				m_left_style = v.Int;
			}
			return m_left_style;
		}

		void putLeftStyle(const int left_style){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "_I", left_style);
			}
			m_left_style = left_style;
		}

		int getRightStyle(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 10, m_range);
				m_right_style = v.Int;
			}
			return m_right_style;
		}

		void putRightStyle(const int right_style){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "__I", right_style);
			}
			m_right_style = right_style;
		}

		int getTopStyle(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 11, m_range);
				m_top_style = v.Int;
			}
			return m_top_style;
		}

		void putTopStyle(const int top_style){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "___I", top_style);
			}
			m_top_style = top_style;
		}

		int getBottomStyle(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 12, m_range);
				m_bottom_style = v.Int;
			}
			return m_bottom_style;
		}

		void putBottomStyle(const int bottom_style){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "____I", bottom_style);
			}
			m_bottom_style = bottom_style;
		}

		void putOutlineColor(const int outline_color){
			int r;
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				r = API.Call(xlcBorder, 0, "______I", outline_color);
			}
			m_outline_color = outline_color;
		}

		int getLeftColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 34, m_range);
				m_left_color = v.Int;
			}
			return m_left_color;
		}

		void putLeftColor(const int left_color){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "_______I", left_color);
			}
			m_left_color = left_color;
		}

		int getRightColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 35, m_range);
				m_right_color = v.Int;
			}
			return m_right_color;
		}

		void putRightColor(const int right_color){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "________I", right_color);
			}
			m_right_color = right_color;
		}

		int getTopColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 36, m_range);
				m_top_color = v.Int;
			}
			return m_top_color;
		}

		void putTopColor(const int top_color){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "_________I", top_color);
			}
			m_top_color = top_color;
		}

		int getBottomColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 37, m_range);
				m_bottom_color = v.Int;
			}
			return m_bottom_color;
		}

		void putBottomColor(const int bottom_color){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcBorder, 0, "__________I", bottom_color);
			}
			m_bottom_color = bottom_color;
		}
	};

	class xlInterior{
		friend class xlRange;

	private:
		xlRange* m_range;
		int m_apattern;
		int m_afore;
		int m_aback;

		void putRange(xlRange* range){
			m_range = range;
		}

		void set(xlRange* range){
			m_range = range;
			API.Call(xlcSelect, 0, "P", m_range);
			API.Call(xlcPatterns, 0, "III", m_apattern, m_afore, m_aback);
		}

	public:
	// cnstructors
		xlInterior(){
			m_apattern = 0;
			m_afore = 0;
			m_aback = 0;
			m_range = NULL;
		}

		xlInterior(int apattern, int afore, int aback){
			m_apattern = apattern;
			m_afore = afore;
			m_aback = aback;
			m_range = NULL;
		}

	// destructor

	// properties
		Property(int, Pattern);
		Property(int, ForeColor);
		Property(int, BackColor);

	// access methods
		int getPattern(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 13, m_range);
				m_apattern = v.Int;
			}
			return m_apattern;
		}

		void putPattern(const int apattern){
			if(m_range){
				API.Call(xlcSelect,0,"P", m_range);
				API.Call(xlcPatterns, 0, "I", apattern);
			}
			m_apattern = apattern;
		}

		int getForeColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 63, m_range);
				m_afore = v.Int;
			}
			return m_afore;
		}

		void putForeColor(const int afore){
			if(m_range){
				API.Call(xlcSelect,0,"P", m_range);
				API.Call(xlcPatterns, 0, "_I", afore);
			}
			m_afore = afore;
		}

		int getBackColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 64, m_range);
				m_aback = v.Int;
			}
			return m_aback;
		}

		void putBackColor(const int aback){
			if(m_range){
				API.Call(xlcSelect,0,"P",m_range);
				API.Call(xlcPatterns, 0, "__I", aback);
			}
			m_aback = aback;
		}

	};

	class xlFont{
		friend class xlRange;

	private:
		xlRange* m_range;
		std::string  m_font_name;
		//std::string  m_font_style;
		double m_size;
		bool   m_strikethrough;
		bool   m_superscript;
		bool   m_subscript;
		bool   m_bold;
		bool   m_italic;
		int    m_underline;
		int    m_color;
		bool   m_normal;
		int    m_background;

		void putRange(xlRange* range){
			m_range = range;
		}

		std::string getFontStyle(bool bold, bool italic){
			std::string s;
			if(bold && italic) return "Bold Italic";
			else if(bold) return "Bold";
			else if(italic) return "Italic";
			else return "";
		}

		void set(xlRange* range){
			std::string fontstyle;
			m_range = range;
			API.Call(xlcSelect, 0, "P", m_range);
			API.Call(xlcFontProperties, 0, "SSNBBB__II",
				m_font_name,
				getFontStyle(m_bold, m_italic),
				m_size, m_strikethrough,
				m_superscript, m_subscript,
				m_underline,
				m_color,
				m_normal,
				m_background
			);
		}

	public:
	// constructors
		xlFont(){
			m_font_name = "MS UI Gothic";
			//m_font_style = "";
			m_size = 11;
			m_strikethrough = 0;
			m_superscript = 0;
			m_subscript = 0;
			m_bold = 0;
			m_italic = 0;
			m_underline = 0;
			m_color = 0;
			m_normal = 0;
			m_background = 1;
			m_range = NULL;
		}

		xlFont(
			const char* font_name,
			//const char* font_style,
			const double size,
			const bool strikethrough,
			const bool superscript,
			const bool subscript,
			const bool bold,
			const bool italic,
			const int  underline,
			const int  color,
			const bool normal,
			const int  background
		){
			m_font_name = font_name;
			//m_font_style = font_style;
			m_size = size;
			m_strikethrough = strikethrough;
			m_superscript = superscript;
			m_subscript = subscript;
			m_bold = bold;
			m_italic = italic;
			m_underline = underline;
			m_color = color;
			m_normal = normal;
			m_background = background;
			m_range = NULL;
		}

	// destructors

	// properties
		Property(std::string, FontName);
		//Property(std::string, FontStyle);
		Property(double, Size);
		Property(bool, Strikethrough);
		Property(bool, Superscript);
		Property(bool, Subscript);
		Property(bool, Bold);
		Property(bool, Italic);
		Property(int,  Underline);
		Property(int,  Color);
		Property(bool, Normal);
		Property(int,  Background);

		Property(bool, Bold);
		Property(bool, Italic);
		
	// access methods
		std::string getFontName(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 18, m_range);
				m_font_name = v.String;
			}
			return m_font_name;
		}

		void putFontName(const char* font_name){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "C", font_name);
			}
			m_font_name = font_name;
		}

		void putFontName(const std::string font_name){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "S", font_name);
			}
			m_font_name = font_name;
		}

		double getSize(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 19, m_range);
				m_size = v.Num;
			}
			return m_size;
		}

		void putSize(const double size){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "__N", size);
			}
			m_size = size;
		}

		bool getStrikethrought(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 23, m_range);
				m_strikethrough = v.Bool;
			}
			return m_strikethrough;
		}

		void putStrikethrough(const bool strikethrough){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "___B", strikethrough);
			}
			m_strikethrough = strikethrough;
		}

		bool getSuperscript(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 57, m_range);
				m_superscript = v.Bool;
			}
			return m_superscript;
		}

		void putSuperscript(const bool superscript){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "____B", superscript);
			}
			m_superscript = superscript;
		}

		bool getSubscript(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 60, m_range);
				m_subscript = v.Bool;
			}
			return m_subscript;
		}

		void putSubscript(const bool subscript){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "_____B", subscript);
			}
			m_subscript = subscript;
		}

		bool getBold(){
			if(m_range){
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 20, m_range);
				m_bold = v.Bool;
			}
			return m_bold;
		}

		void putBold(bool bold){
			if(m_range){
				getItalic();
				std::string s = getFontStyle(bold, m_italic);
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "_S", s);
			}
			m_bold = bold;
		}

		bool getItalic(){
			if(m_range){
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 21, m_range);
				m_italic = v.Bool;
			}
			return m_italic;
		}

		void putItalic(bool italic){
			if(m_range){
				getBold();
				std::string s = getFontStyle(m_bold, italic);
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "_S", s);
			}
			m_italic = italic;
		}

		int getUnderline(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 22, m_range);
				return v.Bool;
			}
			return m_underline;
		}

		void putUnderline(const int underline){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "________I", underline);
			}
			m_underline = underline;
		}

		int getColor(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 24, m_range);
				m_color = v.Int;
			}
			return m_color;
		}

		void putColor(const int color){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "_________I", color);
			}
			m_color = color;
		}

		void putNormal(const bool normal){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "__________B", normal);
			}
			m_normal = normal;
		}

		void putBackground(const int background){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFontProperties, 0, "___________I", background);
			}
			m_background = background;
		}

	};

	class xlAlignment {
		friend class xlRange;

	private:
		xlRange* m_range;
		int m_horiz_align;
		bool m_wrap;
		int m_vert_align;
		int m_orientation;
		bool m_add_indent;

		void putRange(xlRange* range){
			m_range = range;
		}

		void set(xlRange* range){
			m_range = range;
			API.Call(xlcSelect, 0, "P", m_range);
			API.Call(xlcAlignment, 0, "IBIIB", m_horiz_align, m_wrap, m_vert_align, m_orientation, m_add_indent);
		}

	public:
	// constructors
		xlAlignment(){
			m_range = NULL;
			m_horiz_align = 0;
			m_wrap = 0;
			m_vert_align = 0;
			m_orientation = 0;
			m_add_indent = 0;
		}

		xlAlignment(
			const int  horiz_align,
			const bool wrap,
			const int  vert_align,
			const int  orientation,
			const bool  add_indent
		){
			m_range = NULL;
			m_horiz_align = horiz_align;
			m_wrap = wrap;
			m_vert_align = vert_align;
			m_orientation = orientation;
			m_add_indent = add_indent;
		}

	// properties
		Property(int,  HorizAlign);
		Property(int,  VertAlign);
		Property(bool, Wrap);
		Property(int,  Orientation);
		Property(bool,  AddIndent);

	// access methods
		int getHorizAlign(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 8, m_range);
				m_horiz_align = v.Int;
			}
			return m_horiz_align;
		}

		void putHorizAlign(int horiz_align){
			int r;
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				r = API.Call(xlcAlignment, 0, "I", horiz_align);
				r = 0;
			}
			m_horiz_align = horiz_align;
		}

		bool getWrap(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 33, m_range);
				m_wrap = v.Bool;
			}
			return m_wrap;
		}

		void putWrap(bool wrap){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcAlignment, 0, "_B", wrap);
			}
			m_wrap = wrap;
		}

		int getVertAlign(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 50, m_range);
				m_vert_align = v.Int;
			}
			return m_vert_align;
		}

		void putVertAlign(int vert_align){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcAlignment, 0, "__I", vert_align);
			}
			m_vert_align = vert_align;
		}

		int getOrientation(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 51, m_range);
				m_orientation = v.Int;
			}
			return m_orientation;
		}

		void putOrientation(int orientation){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcAlignment, 0, "___I", orientation);
			}
			m_orientation = orientation;
		}

		bool getAddIndent(){
			if(m_range) {
				xlVar v;
				API.Call(xlfGetCell, &v, "IP", 65, m_range);
				m_add_indent = v.Bool;
			}
			return m_add_indent;
		}

		void putAddIndent(bool add_indent){
			if(m_range){
				API.Call(xlcSelect, 0, "P", m_range);
				API.Call(xlcFormatText, 0, "____B", add_indent);
			}
			m_add_indent = add_indent;
		}

	};


}