/*
	A sample of AXL3 library. To use this program,

	1.	Create new DLL project from Visual C++ IDE.
	2.	Add include path to 'axl3.h' if needed.
	3.	In property page of Project, modify 'Output file' to 
		"$(OutDir)\$(ProjectName).xll" in 'Linker' section.
	4.	Add this file to your project.
	5.	Build your project.
	6.	Copy built xll file to your 'AddIns' folder.
	7.	In Excel, Check on "Sample of AXL3" in add-ins dialog box.
*/


#include "stdafx.h" // If you don't use pre compiled header and stdafx (recommended),
                    // remove or comment out this line.

#include "axl3.h"   // You may write follows directives in 'stdafx.h'. 

#if _DEBUG
#	define	CRTDBG_MAP_ALLOC // for memory leak check.
#	include <stdlib.h>
#	include <crtdbg.h>
#endif

using namespace xl;

XL_AUTO_OPEN_BEGIN
#if _DEBUG
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF); // for memory leak check.
#endif
	
	// Register menu using xlVar's Array.
	xlVar mn(4,5);
	mn[0] = xlVar::NewArray("W5", L"AXL3Test", L"", L"", L"sample of AXL3", L"");
	mn[1] = xlVar::NewArray("C5", "&Test1", "test1", "", "", "");
	mn[2] = xlVar::NewArray("C5", "-", "", "", "", "");
	mn[3] = xlVar::NewArray("C5", "&ClearResult", "ClearResult", "", "", "");
	if(XLM.GetBar(10, "AXL3Test").IsError()) XLM.AddMenu(10, mn);

	// Add events to Excel.
	XLM.OnDoubleclick("[Mytest.xls]Sheet1", "OnDoubleClick");
	XLM.OnWindow("Mytest.xls", "onWindow");

	// Register event handler.
	xlCmd("test1","test1").Register();
	xlCmd("onWindow", "onWindow").Register();
	xlCmd("OnDoubleClick","OnDoubleClick").Register();
	xlCmd("ClearResult","ClearResult").Register();

	//Register User Defined Function.
	xlFunc("MyFunc","MyFunc","UUU").Register();

XL_AUTO_OPEN_END

XL_ADDIN_MANAGER_INFO("Sample of AXL3") // Sets title of this add-in to add-in manager dialog.

XL_EXPORT void xlAutoClose(){
	// Remove added menu from Excel before close.
	if(!XLM.GetBar(10, "AXL3Test").IsError()) XLM.DeleteMenu(10, "AXL3Test");
}

XL_EXPORT void* MyFunc(void* arg1, void* arg2){
	xlVar a1(arg1, asArgFromXL);
	xlVar a2(arg2, asArgFromXL);
	return (xlVar("result = ") + (a1.First + a2.First)).AsResToXL();
	//'First' method returns the first element when it is an array, otherwise returns itself.
}

XL_EXPORT void test1(){
	XLM.Alert("Test1 called!");
}

XL_EXPORT void onWindow(){
	xlSheet sh = xlSheet::ActiveSheet();
	XLM.Alert(xlVar("Window changed! ActiveSheet is ") + sh.Name);
}

XL_EXPORT void OnDoubleClick(){
	xlRange rn = XLM.Caller(); // You may use "rn = xlRange::ActiveCell();" instead. 
	if(rn.Column != 4 && rn.Row != 0) return;
	xlSheet sh = xlSheet::ActiveSheet();
	xlRange cell = sh.Range(1,5);
	cell.Value = xlBook::ThisBook().Name;
	cell.ChangeRef(2,5).Value = xlSheet::ActiveSheet().Name; // ChangeRef is fast.
	cell.ChangeRef(3,5).Value = xlBook::ThisBook().NamesOfAllSheets().CountCols();
	cell.ChangeRef(4,5).Value = xlVar("R") + (rn.Row + 1) + "C" + (rn.Column + 1);
	cell.ChangeRef(5,5).Formula = "=R6C2";
	cell.Border = xlBorder(1,3,3,3,3,4,3,3,3,3);
	cell.Interior = xlInterior(18, 5, 0);
	cell.Font.FontName = "MS UI Gothic";
	cell.Font.Color = 3;
	cell.Font.Bold = true;
	cell.Font.Italic = true;
	cell.Hidden=true;
	cell.Alignment.HorizAlign = 3;
	cell.Alignment.VertAlign = 2;
	sh.Protect("foobar");
}

XL_EXPORT void ClearResult(){
	xlSheet::ActiveSheet().UnProtect("foobar");
	xlRange(1,5,5,5).ClearContents();
	xlRange rn(5,5);
	rn.ClearAll();
	rn.Border.OutlineColor = 1;
}