package cerot.blight.sequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;

import com.mxgraph.swing.mxGraphComponent;

import junit.framework.TestCase;
import cerot.blight.btrace.BTraceConverter;
import cerot.blight.btrace.MethodExpression;
import cerot.blight.sequence.entity.Connector;
import cerot.util.ResourceUtils;

public class SequenceCreatorTest extends TestCase {
	public void testCreateGraphComponent_描画() throws IOException,
			InterruptedException {
		List<Connector> connectorList = createConnectorList("/cerot/blight/sequence/SequenceCreatorTest.txt");
		SequenceCreator sequence = new SequenceCreator(connectorList);
		mxGraphComponent component = sequence.createGraphComponent();

		JFrame frame = new JFrame();
		frame.getContentPane().add(component);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.pack();
		frame.setTitle("Sequence Diagram");
		frame.setVisible(true);

		Thread.currentThread().join();
	}

	private List<Connector> createConnectorList(String resourceName)
			throws IOException {
		List<MethodExpression> methodList = new ArrayList<MethodExpression>();
		List<String> lineList = ResourceUtils.readResourceToList(resourceName);
		for (String line : lineList) {
			MethodExpression method = BTraceConverter.toMethodExpression(0,
					line);
			methodList.add(method);
		}

		List<Connector> result = SequenceConverter.toConnectorList(methodList);
		return result;
	}
}
