/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64OutputStream
extends FilterOutputStream {
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] intToBase64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte PAD = 61;
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final int encodeSize;
    private byte[] buf = new byte[1024];
    private int pos;
    private int currentLinePos;
    private int modulus;
    private boolean closed = false;
    private int x;
    private final byte[] singleByte = new byte[1];

    public Base64OutputStream(OutputStream os) {
        this(os, 76, CHUNK_SEPARATOR);
    }

    public Base64OutputStream(OutputStream os, int lineLength) {
        this(os, lineLength, CHUNK_SEPARATOR);
    }

    public Base64OutputStream(OutputStream os, int lineLength, byte[] lineSeparator) {
        super(os);
        this.lineLength = lineLength;
        this.lineSeparator = new byte[lineSeparator.length];
        System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
        this.encodeSize = lineLength > 0 ? 4 + lineSeparator.length : 4;
        if (Base64OutputStream.containsBase64Byte(lineSeparator)) {
            String sep;
            try {
                sep = new String(lineSeparator, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                sep = new String(lineSeparator);
            }
            throw new IllegalArgumentException("lineSeperator must not contain base64 characters: [" + sep + "]");
        }
    }

    private void resizeBuf() {
        byte[] b = new byte[this.buf.length * 2];
        System.arraycopy(this.buf, 0, b, 0, this.buf.length);
        this.buf = b;
    }

    public static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < base64ToInt.length && base64ToInt[octet] != -1;
    }

    private static boolean containsBase64Byte(byte[] arrayOctet) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (!Base64OutputStream.isBase64(arrayOctet[i])) continue;
            return true;
        }
        return false;
    }

    public void write(int i) throws IOException {
        this.singleByte[0] = (byte)i;
        this.write(this.singleByte, 0, 1);
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Base64OutputStream has been closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (len < 0) {
            this.closed = true;
            if (this.buf.length - this.pos < this.encodeSize) {
                this.resizeBuf();
            }
            switch (this.modulus) {
                case 1: {
                    this.buf[this.pos++] = intToBase64[this.x >> 2 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 4 & 0x3F];
                    this.buf[this.pos++] = 61;
                    this.buf[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buf[this.pos++] = intToBase64[this.x >> 10 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 4 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 2 & 0x3F];
                    this.buf[this.pos++] = 61;
                }
            }
            if (this.lineLength > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
                System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            if (offset < 0 || len < 0 || offset + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (offset > b.length || offset + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    int bc;
                    if (this.buf.length - this.pos < this.encodeSize) {
                        this.resizeBuf();
                    }
                    ++this.modulus;
                    this.modulus %= 3;
                    if ((bc = b[offset++]) < 0) {
                        bc += 256;
                    }
                    this.x = (this.x << 8) + bc;
                    if (0 != this.modulus) continue;
                    this.buf[this.pos++] = intToBase64[this.x >> 18 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 12 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 6 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x & 0x3F];
                    this.currentLinePos += 4;
                    if (this.lineLength <= 0 || this.lineLength > this.currentLinePos) continue;
                    System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                    this.pos += this.lineSeparator.length;
                    this.currentLinePos = 0;
                }
            }
        }
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        if (this.pos > 0) {
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.write(this.singleByte, 0, -1);
            this.flush();
        }
        finally {
            this.closed = true;
        }
    }
}

