package cerot.blight.view.callstack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JFrame;

import junit.framework.TestCase;
import cerot.blight.btrace.BTraceConverter;
import cerot.blight.btrace.MethodExpression;
import cerot.util.ResourceUtils;

public class CallStackCreatorTest extends TestCase {
	public void testCreateGraphComponent_描画() throws IOException,
			InterruptedException {
		List<MethodExpression> methodExpressionList = createMethodExpressionList("/cerot/blight/view/callstack/CallStackCreatorTest.txt");
		CallStackCreator sequence = new CallStackCreator(methodExpressionList);
		JComponent component = sequence.createComponent();

		JFrame frame = new JFrame();
		frame.getContentPane().add(component);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.pack();
		frame.setTitle("Sequence Diagram");
		frame.setVisible(true);

		Thread.currentThread().join();
	}

	private List<MethodExpression> createMethodExpressionList(
			String resourceName) throws IOException {
		List<MethodExpression> result = new ArrayList<MethodExpression>();
		List<String> lineList = ResourceUtils.readResourceToList(resourceName);
		for (String line : lineList) {
			MethodExpression method = BTraceConverter.toMethodExpression(line);
			result.add(method);
		}

		return result;
	}
}
