package cerot.tools.redmine.timelog.accessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

/**
 * ログインのレスポンスハンドラクラス。
 * @author cero-t
 * 
 */
public class LoginResponseHandler implements ResponseHandler<Boolean> {
	/** ログイン成功のメッセージ */
	private static final String LOGIN_SUCCESS = "ログイン中：";

	/** ログイン失敗のメッセージ */
	private static final String LOGIN_FAILURE = "ユーザ名もしくはパスワードが無効";

	/**
	 * {@inheritDoc}<br>
	 * ログインに成功した場合はTRUE、失敗した場合はFALSEを返します。
	 */
	@Override
	public Boolean handleResponse(HttpResponse response) throws IOException {
		HttpEntity entity = response.getEntity();
		if (entity == null) {
			return Boolean.FALSE;
		}

		BufferedReader reader = null;
		InputStream in = entity.getContent();
		try {
			reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));

			String line = null;
			while ((line = reader.readLine()) != null) {
				if (line.contains(LOGIN_SUCCESS)) {
					return Boolean.TRUE;
				} else if (line.contains(LOGIN_FAILURE)) {
					return Boolean.FALSE;
				}
			}
		} finally {
			if (reader != null) {
				reader.close();
			} else {
				in.close();
			}
		}

		return Boolean.FALSE;
	}
}
