package cerot.tools.taskcoach.entity;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * タスクのモデルクラス。
 * @author cero-t
 * 
 */
public class Task {
	/** ID */
	@XmlAttribute
	public String id;

	/** タスク名 */
	@XmlAttribute
	public String subject;

	/** 内容 */
	@XmlAttribute
	public String description;

	/** 開始日 */
	@XmlAttribute
	public Date startdate;

	/** 完了日 */
	@XmlAttribute
	public Date completedate;

	/** 予定時間 */
	@XmlAttribute
	public String budget;

	/** 拡張コンテキスト */
	@XmlAttribute
	public String expandedContexts;

	/** エフォートのリスト */
	@XmlElement(name = "effort")
	public List<Effort> effortList;

	/** タスクのリスト */
	@XmlElement(name = "task")
	public List<Task> taskList;

	/** ステータス */
	@XmlAttribute
	public String status;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
