/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.Verifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MethodVerifier
extends MethodAdapter {
    private static Set<String> primitiveWrapperTypes = new HashSet<String>();
    private static Set<String> unboxMethods = new HashSet<String>();
    private String className;
    private Map<Label, Label> labels;

    public MethodVerifier(MethodVisitor mv, String className) {
        super(mv);
        this.className = className;
        this.labels = new HashMap<Label, Label>();
    }

    @Override
    public void visitEnd() {
        this.labels.clear();
        super.visitEnd();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 181) {
            this.reportError("no.assignment");
        }
        if (opcode == 179 && !owner.equals(this.className)) {
            this.reportError("no.assignment");
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.reportError("no.assignment");
                break;
            }
            case 191: {
                this.reportError("no.throw");
                break;
            }
            case 194: 
            case 195: {
                this.reportError("no.synchronized.blocks");
            }
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            this.reportError("no.array.creation");
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (this.labels.get(label) != null) {
            this.reportError("no.loops");
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.labels.put(label, label);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.reportError("no.class.literals", cst.toString());
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        switch (opcode) {
            case 182: {
                if (MethodVerifier.isPrimitiveWrapper(owner) && unboxMethods.contains(name)) break;
                this.reportError("no.method.calls", owner + "." + name + desc);
                break;
            }
            case 185: {
                this.reportError("no.method.calls", owner + "." + name + desc);
                break;
            }
            case 183: {
                if (owner.equals(Constants.JAVA_LANG_OBJECT) && name.equals("<init>")) break;
                this.reportError("no.method.calls", owner + "." + name + desc);
                break;
            }
            case 184: {
                if (owner.equals(Constants.BTRACE_UTILS) || "valueOf".equals(name) && MethodVerifier.isPrimitiveWrapper(owner)) break;
                this.reportError("no.method.calls", owner + "." + name + desc);
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.reportError("no.array.creation");
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.reportError("no.catch");
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 189) {
            this.reportError("no.array.creation", desc);
        }
        if (opcode == 187) {
            this.reportError("no.new.object", desc);
        }
        super.visitTypeInsn(opcode, desc);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 169) {
            this.reportError("no.try");
        }
        super.visitVarInsn(opcode, var);
    }

    private void reportError(String err) {
        this.reportError(err, null);
    }

    private void reportError(String err, String msg) {
        Verifier.reportError(err, msg);
    }

    private static boolean isPrimitiveWrapper(String type) {
        return primitiveWrapperTypes.contains(type);
    }

    static {
        primitiveWrapperTypes.add("java/lang/Boolean");
        primitiveWrapperTypes.add("java/lang/Byte");
        primitiveWrapperTypes.add("java/lang/Character");
        primitiveWrapperTypes.add("java/lang/Short");
        primitiveWrapperTypes.add("java/lang/Integer");
        primitiveWrapperTypes.add("java/lang/Long");
        primitiveWrapperTypes.add("java/lang/Float");
        primitiveWrapperTypes.add("java/lang/Double");
        unboxMethods.add("booleanValue");
        unboxMethods.add("byteValue");
        unboxMethods.add("charValue");
        unboxMethods.add("shortValue");
        unboxMethods.add("intValue");
        unboxMethods.add("longValue");
        unboxMethods.add("floatValue");
        unboxMethods.add("doubleValue");
    }
}

