/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.client;

import com.sun.btrace.CommandListener;
import com.sun.btrace.annotations.DTrace;
import com.sun.btrace.annotations.DTraceRef;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.EventCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.InstrumentCommand;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.comm.WireIO;
import com.sun.btrace.compiler.Compiler;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.util.NullVisitor;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class Client {
    private static boolean dtraceEnabled;
    private static Method submitFile;
    private static Method submitString;
    private static final String DTRACE_DESC;
    private static final String DTRACE_REF_DESC;
    private final int port;
    private final boolean debug;
    private final boolean dumpClasses;
    private final String dumpDir;
    private final String probeDescPath;
    private volatile Socket sock;
    private volatile ObjectInputStream ois;
    private volatile ObjectOutputStream oos;

    public Client(int port) {
        this(port, ".", false, false, null);
    }

    public Client(int port, String probeDescPath) {
        this(port, probeDescPath, false, false, null);
    }

    public Client(int port, String probeDescPath, boolean debug, boolean dumpClasses, String dumpDir) {
        this.port = port;
        this.probeDescPath = probeDescPath;
        this.debug = debug;
        this.dumpClasses = dumpClasses;
        this.dumpDir = dumpDir;
    }

    public byte[] compile(String fileName, String classPath) {
        return this.compile(fileName, classPath, new PrintWriter(System.err), null);
    }

    public byte[] compile(String fileName, String classPath, String includePath) {
        return this.compile(fileName, classPath, new PrintWriter(System.err), includePath);
    }

    public byte[] compile(String fileName, String classPath, PrintWriter err) {
        return this.compile(fileName, classPath, err, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] compile(String fileName, String classPath, PrintWriter err, String includePath) {
        byte[] code = null;
        File file = new File(fileName);
        if (fileName.endsWith(".java")) {
            Map<String, byte[]> classes;
            Compiler compiler = new Compiler(includePath);
            classPath = classPath + File.pathSeparator + System.getProperty("java.class.path");
            if (this.debug) {
                this.debugPrint("compiling " + fileName);
            }
            if ((classes = compiler.compile(file, (Writer)err, ".", classPath)) == null) {
                err.println("btrace compilation failed!");
                return null;
            }
            int size = classes.size();
            if (size != 1) {
                err.println("no classes or more than one class");
                return null;
            }
            String name = classes.keySet().iterator().next();
            code = classes.get(name);
            if (!this.debug) return code;
            this.debugPrint("compiled " + fileName);
            return code;
        }
        if (fileName.endsWith(".class")) {
            code = new byte[(int)file.length()];
            try {
                FileInputStream fis = new FileInputStream(file);
                if (this.debug) {
                    this.debugPrint("reading " + fileName);
                }
                try {
                    fis.read(code);
                }
                finally {
                    fis.close();
                }
                if (!this.debug) return code;
                this.debugPrint("read " + fileName);
                return code;
            }
            catch (IOException exp) {
                err.println(exp.getMessage());
                return null;
            }
        }
        err.println("BTrace script has to be a .java or a .class");
        return null;
    }

    public void attach(String pid) throws IOException {
        try {
            String agentPath = "/btrace-agent.jar";
            String tmp = Client.class.getClassLoader().getResource("com/sun/btrace").toString();
            tmp = tmp.substring(0, tmp.indexOf("!"));
            tmp = tmp.substring("jar:".length(), tmp.lastIndexOf("/"));
            agentPath = tmp + agentPath;
            agentPath = new File(new URI(agentPath)).getAbsolutePath();
            this.attach(pid, agentPath, null, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ioexp) {
            throw ioexp;
        }
        catch (Exception exp) {
            throw new IOException(exp.getMessage());
        }
    }

    public void attach(String pid, String agentPath, String sysCp, String bootCp) throws IOException {
        try {
            VirtualMachine vm = null;
            if (this.debug) {
                this.debugPrint("attaching to " + pid);
            }
            vm = VirtualMachine.attach(pid);
            if (this.debug) {
                this.debugPrint("attached to " + pid);
            }
            if (this.debug) {
                this.debugPrint("loading " + agentPath);
            }
            String agentArgs = "port=" + this.port;
            if (this.debug) {
                agentArgs = agentArgs + ",debug=true";
            }
            if (this.dumpClasses) {
                agentArgs = agentArgs + ",dumpClasses=true";
                agentArgs = agentArgs + ",dumpDir=" + this.dumpDir;
            }
            if (bootCp != null) {
                agentArgs = agentArgs + ",bootClassPath=" + bootCp;
            }
            if (sysCp == null) {
                sysCp = this.getToolsJarPath();
            }
            agentArgs = agentArgs + ",systemClassPath=" + sysCp;
            agentArgs = agentArgs + ",probeDescPath=" + this.probeDescPath;
            if (this.debug) {
                this.debugPrint("agent args: " + agentArgs);
            }
            vm.loadAgent(agentPath, agentArgs);
            if (this.debug) {
                this.debugPrint("loaded " + agentPath);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ioexp) {
            throw ioexp;
        }
        catch (Exception exp) {
            throw new IOException(exp.getMessage());
        }
    }

    public void submit(String fileName, byte[] code, String[] args, CommandListener listener) throws IOException {
        if (this.sock != null) {
            throw new IllegalStateException();
        }
        this.submitDTrace(fileName, code, args, listener);
        try {
            if (this.debug) {
                this.debugPrint("opening socket to " + this.port);
            }
            this.sock = new Socket("localhost", this.port);
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            if (this.debug) {
                this.debugPrint("sending instrument command");
            }
            WireIO.write(this.oos, new InstrumentCommand(code, args));
            this.ois = new ObjectInputStream(this.sock.getInputStream());
            if (this.debug) {
                this.debugPrint("entering into command loop");
            }
            this.commandLoop(listener);
        }
        catch (UnknownHostException uhe) {
            throw new IOException(uhe);
        }
    }

    public void submit(byte[] code, String[] args, CommandListener listener) throws IOException {
        this.submit(null, code, args, listener);
    }

    public void sendExit() throws IOException {
        this.sendExit(0);
    }

    public void sendExit(int code) throws IOException {
        this.send(new ExitCommand(code));
    }

    public void sendEvent() throws IOException {
        this.sendEvent("");
    }

    public void sendEvent(String name) throws IOException {
        this.send(new EventCommand(name));
    }

    public synchronized void close() throws IOException {
        if (this.ois != null) {
            this.ois.close();
        }
        if (this.oos != null) {
            this.oos.close();
        }
        if (this.sock != null) {
            this.sock.close();
        }
        this.reset();
    }

    private void reset() {
        this.sock = null;
        this.ois = null;
        this.oos = null;
    }

    private String getToolsJarPath() {
        String[] components;
        for (String c : components = System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!c.endsWith("tools.jar")) continue;
            return new File(c).getAbsolutePath();
        }
        return System.getProperty("java.home") + "../lib/tools.jar";
    }

    private void send(Command cmd) throws IOException {
        if (this.oos == null) {
            throw new IllegalStateException();
        }
        this.oos.reset();
        WireIO.write(this.oos, cmd);
    }

    private void commandLoop(CommandListener listener) throws IOException {
        assert (this.ois != null) : "null input stream?";
        AtomicBoolean exited = new AtomicBoolean(false);
        while (true) {
            try {
                Command cmd;
                do {
                    cmd = WireIO.read(this.ois);
                    if (this.debug) {
                        this.debugPrint("received " + cmd);
                    }
                    listener.onCommand(cmd);
                } while (cmd.getType() != 2);
                return;
            }
            catch (IOException e) {
                if (exited.compareAndSet(false, true)) {
                    listener.onCommand(new ExitCommand(-1));
                }
                throw e;
            }
            catch (NullPointerException e) {
                if (!exited.compareAndSet(false, true)) continue;
                listener.onCommand(new ExitCommand(-1));
                continue;
            }
            break;
        }
    }

    public void debugPrint(String msg) {
        System.out.println("DEBUG: " + msg);
    }

    private void warn(CommandListener listener, String msg) {
        block2: {
            try {
                msg = "WARNING: " + msg + "\n";
                listener.onCommand(new MessageCommand(msg));
            }
            catch (IOException exp) {
                if (!this.debug) break block2;
                exp.printStackTrace();
            }
        }
    }

    private void submitDTrace(String fileName, byte[] code, String[] args, CommandListener listener) {
        if (fileName == null || code == null) {
            return;
        }
        Object dtraceSrc = this.getDTraceSource(fileName, code);
        try {
            if (dtraceSrc instanceof String) {
                if (dtraceEnabled) {
                    submitString.invoke(null, dtraceSrc, args, listener);
                } else {
                    this.warn(listener, "@DTrace is supported only on Solaris 11+");
                }
            } else if (dtraceSrc instanceof File) {
                if (dtraceEnabled) {
                    submitFile.invoke(null, dtraceSrc, args, listener);
                } else {
                    this.warn(listener, "@DTraceRef is supported only on Solaris 11+");
                }
            }
        }
        catch (IllegalAccessException iace) {
            iace.printStackTrace();
        }
        catch (IllegalArgumentException iarge) {
            iarge.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getTargetException());
        }
    }

    private Object getDTraceSource(final String fileName, byte[] code) {
        ClassReader reader = new ClassReader(code);
        final Object[] result = new Object[1];
        reader.accept((ClassVisitor)new NullVisitor(){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean vis) {
                if (desc.equals(DTRACE_DESC)) {
                    return new NullVisitor(){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("value")) {
                                result[0] = value;
                            }
                        }
                    };
                }
                if (desc.equals(DTRACE_REF_DESC)) {
                    return new NullVisitor(){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("value")) {
                                String tmp = value.toString();
                                File file = new File(tmp);
                                if (file.isAbsolute()) {
                                    result[0] = file;
                                } else {
                                    int index = fileName.lastIndexOf(File.separatorChar);
                                    String dir = index == -1 ? "." : fileName.substring(0, index);
                                    result[0] = new File(dir, tmp);
                                }
                            }
                        }
                    };
                }
                return super.visitAnnotation(desc, vis);
            }
        }, 1);
        return result[0];
    }

    static {
        try {
            Class<?> dtraceConsumerClass = Class.forName("org.opensolaris.os.dtrace.Consumer");
            Class<?> dtraceClass = Class.forName("com.sun.btrace.dtrace.DTrace");
            dtraceEnabled = true;
            submitFile = dtraceClass.getMethod("submit", File.class, String[].class, CommandListener.class);
            submitString = dtraceClass.getMethod("submit", String.class, String[].class, CommandListener.class);
        }
        catch (Exception exp) {
            dtraceEnabled = false;
        }
        DTRACE_DESC = Type.getDescriptor(DTrace.class);
        DTRACE_REF_DESC = Type.getDescriptor(DTraceRef.class);
    }
}

