//: CMRHostHandler.h
/**
  * $Id: CMRHostHandler.h,v 1.1.1.1 2005-05-11 17:51:06 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

#import <Foundation/Foundation.h>


@interface CMRHostHandler : NSObject
{

}
+ (id) hostHandlerForURL : (NSURL *) anURL;

// Managing subclasses
+ (BOOL) canHandleURL : (NSURL *) anURL;
+ (void) registerHostHandlerClass : (Class) aHostHandlerClass;

- (NSDictionary *) properties;
- (NSString *) name;
- (NSString *) identifier;

- (BOOL) canReadDATFile;

/*
----------------------------------------
CES (Code Encoding Scheme)
----------------------------------------
Shift JIS ɂĂ͑Ή镄WƂĎO
₪lB

  - JIS Kiɒ JIS X 0208:1997
  - MicroSoft Ђ̎dl
  - Apple Ђ̎dl

͈ȉ CFStringEncodings ɑΉiʓ
CFStringConvertEncodingToIANACharSetName() ̕ԂOj

  - kCFStringEncodingShiftJIS (SHIFT_JIS)
  - kCFStringEncodingDOSJapanese (CP932)
  - kCFStringEncodingMacJapanese (X-MAC-JAPANESE)

CocoMonar ̏ꍇAƂΐVEmac ł Mac Japanese 
R[hgP[X邽߁AShift JIS ɊւĂ
炷ׂĂɑΉ̂IƎvB

̂߁Aȉ̃\bhł CFStringEncoding 
Ԃꍇ
(1) ܂ÃGR[fBO
(2) ŕϊłȂΎc̃GR[fBȌԂŎB
(3) ʓIɕϊłȂ΃G[

  - kCFStringEncodingDOSJapanese
  - kCFStringEncodingMacJapanese
  - kCFStringEncodingShiftJIS

NOTE:
ۂ̕ϊ[` CMXTextParser.h ɂB
----------------------------------------
*/
- (CFStringEncoding) subjectEncoding;
- (CFStringEncoding) threadEncoding;

/* 
	anURL = fURL܂URL
	bbs = ffBNg 
*/
- (NSURL *) boardURLWithURL : (NSURL    *) anURL
						bbs : (NSString *) bbs;
- (NSURL *) datURLWithBoard : (NSURL    *) boardURL
                    datName : (NSString *) datName;

- (NSDictionary *) readCGIProperties;
- (NSURL *) readURLWithBoard : (NSURL    *) boardURL;
- (NSURL *) readURLWithBoard : (NSURL    *) boardURL
                     datName : (NSString *) datName;
- (NSURL *) readURLWithBoard : (NSURL    *) boardURL
                     datName : (NSString *) datName
					paramStr : (NSString *) paramStr;
- (NSURL *) readURLWithBoard : (NSURL    *) boardURL
                     datName : (NSString *) datName
					   start : (unsigned  ) startIndex
					     end : (unsigned  ) endIndex
					 nofirst : (BOOL      ) nofirst;

- (BOOL) parseParametersWithReadURL : (NSURL        *) link
                                bbs : (NSString    **) bbs
                                key : (NSString    **) key
                              start : (unsigned int *) startIndex
                                 to : (unsigned int *) endIndex
                          showFirst : (BOOL         *) showFirst;



// parse HTML
- (id) parseHTML : (NSString *) inputSource
			with : (id        ) thread
		   count : (unsigned  ) loadedCount;
@end



@interface CMRHostHandler(WriteCGI)
/* write.cgi parameter names */
#define CMRHostFormSubmitKey	@"submit"
#define CMRHostFormNameKey		@"name"
#define CMRHostFormMailKey		@"mail"
#define CMRHostFormMessageKey	@"message"
#define CMRHostFormBBSKey		@"bbs"
#define CMRHostFormIDKey		@"key"
#define CMRHostFormDirectoryKey	@"directory"
#define CMRHostFormTimeKey		@"time"
- (NSDictionary *) formKeyDictionary;

- (NSURL *) writeURLWithBoard : (NSURL *) boardURL;
- (NSString *) submitValue;
@end
