/**
  * $Id: CMRStatusLineWindowController.m,v 1.9.2.3 2006-11-06 15:12:08 tsawada2 Exp $
  * BathyScaphe
  *
  *  CMRStatusLineWindowController  CMRToolbarWindowController 𓝍
  * Copyright 2006 BathyScaphe Project. All rights reserved.
  *
  */

#import "CMRStatusLineWindowController.h"
#import "CMRTask.h"
#import "CMRTaskManager.h"

@implementation CMRStatusLineWindowController
- (void) dealloc
{
	[m_statusLine setDelegate: nil];
	[m_statusLine release];
	[m_toolbarDelegateImp release];
	[super dealloc];
}

+ (Class) toolbarDelegateImpClass
{
	return Nil;
}

- (id<CMRToolbarDelegate>) toolbarDelegate
{
	if(nil == m_toolbarDelegateImp){
		Class		class_;
		
		class_ = [[self class] toolbarDelegateImpClass];
		UTILAssertConformsTo(class_, @protocol(CMRToolbarDelegate));

		m_toolbarDelegateImp = [[class_ alloc] init];
	}
	return m_toolbarDelegateImp;
}

// board / thread signature for historyManager .etc
- (id) boardIdentifier
{
	UTILAbstractMethodInvoked;
	return nil;
}
- (id) threadIdentifier
{
	UTILAbstractMethodInvoked;
	return nil;
}

// Keybinding support
- (void) selectNextKeyView : (id) sender
{
	[[self window] selectNextKeyView : sender];
}
- (void) selectPreviousKeyView : (id) sender
{
	[[self window] selectPreviousKeyView : sender];
}

// Window Management
- (void) windowDidLoad
{
	[super windowDidLoad];
	[[self window] setAutodisplay : NO];
	[[self window] setViewsNeedDisplay : NO];
	[self setupUIComponents];
	[[self window] setViewsNeedDisplay : YES];
	[[self window] setAutodisplay : YES];
}

- (BOOL) validateMenuItem : (NSMenuItem *) theItem
{
	SEL action_;
	
	if (nil == theItem) return NO;
	action_ = [theItem action];
	
	// uEChËʒuƗ̈Lv
	if (action_ == @selector(saveAsDefaultFrame:)) {
		return YES;
	}
	if (action_ == @selector(cancelCurrentTask:)) {
		id<CMRTask> tm = [CMRTaskManager defaultManager];
		return ([tm isInProgress]);
	}	
	return NO;
}

- (BOOL) validateToolbarItem : (NSToolbarItem *) item_
{
	SEL	action_;
	action_ = [item_ action];
	if (action_ == @selector(cancelCurrentTask:)) { 
		return ([[CMRTaskManager defaultManager] isInProgress]); 
	} else {	
		NSString		*identifier_;
		NSToolbarItem	*theItem_;
		
		identifier_ = [item_ itemIdentifier];
		theItem_ = [[self toolbarDelegate] itemForItemIdentifier: identifier_];
		
		return (theItem_ == item_);
	}
}

// delegate
- (void) windowWillRunToolbarCustomizationPalette: (NSWindow *) sender
{
	[[[self statusLine] progressIndicator] setDisplayedWhenStopped : YES];
}

- (void)windowDidEndSheet:(NSNotification *)aNotification
{
	[[[self statusLine] progressIndicator] setDisplayedWhenStopped : NO];
}
@end

@implementation CMRStatusLineWindowController(ViewInitializer)
- (void) setupUIComponents
{
	[[self toolbarDelegate] attachToolbarWithWindow : [self window]];
	[[self window] setDelegate : self];
	[self setupStatusLine];
}

+ (Class) statusLineClass
{
	return [CMRStatusLine class];
}

- (NSString *) statusLineFrameAutosaveName
{
	UTILAbstractMethodInvoked;
	return nil;
}

- (void) setupStatusLine
{
	UTILAssertNotNil([self statusLine]);
}

- (CMRStatusLine *) statusLine
{
	if (nil == m_statusLine) {
		m_statusLine = [[[[self class] statusLineClass] alloc] initWithIdentifier: [self statusLineFrameAutosaveName]];
		[m_statusLine setDelegate : self];
	}
	return m_statusLine;
}
@end

@implementation CMRStatusLineWindowController(Action)
// uEChËʒuƗ̈Lv
- (IBAction) saveAsDefaultFrame : (id) sender;
{
	UTILAbstractMethodInvoked;
}
- (IBAction) cancelCurrentTask : (id) sender;
{
	[[CMRTaskManager defaultManager] cancel : sender];
}
@end
