//
//  CMRStatusLine.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 08/03/14.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>

@class BSStatusLineView;

@interface CMRStatusLine : NSObject {
	id								_delegate;
	
	IBOutlet BSStatusLineView		*_statusLineView;
    IBOutlet NSTabView  *m_tabView;
	IBOutlet NSProgressIndicator	*_progressIndicator;
	IBOutlet NSObjectController		*_objectController;
}

- (id)initWithDelegate:(id)delegate;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (BSStatusLineView *)statusLineView;
- (NSProgressIndicator *)progressIndicator;
- (NSObjectController *)taskObjectController;
- (NSTabView *)tabView;

- (void)setupUIComponents;
- (void)statusLineViewDidMoveToWindow;
- (void)statusLineWillRemoveFromWindow;
@end
