//
//  CMRThreadViewerTbDelegate.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 07/08/05.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "CMRThreadViewerTbDelegate.h"
#import "CMRToolbarDelegateImp_p.h"
#import "AppDefaults.h"

// スレッドの更新
static NSString *const st_reloadItem_Identifier				= @"Reload Thread";
static NSString *const st_reloadItem_LabelKey				= @"Reload Thread Label";
static NSString *const st_reloadItem_PaletteLabelKey		= @"Reload Thread Palette Label";
static NSString *const st_reloadItem_ToolTipKey				= @"Reload Thread ToolTip";
static NSString *const st_reloadThread_imageName			= @"ReloadThread";

// レス
static NSString *const st_ReplyItem_Identifier			= @"Reply";
static NSString *const st_ReplyItem_LabelKey			= @"Reply Label";
static NSString *const st_ReplyItem_PaletteLabelKey		= @"Reply Palette Label";
static NSString *const st_ReplyItem_ToolTipKey			= @"Reply ToolTip";
static NSString *const st_ReplyItem_imageName			= @"ResToThread";

//「お気に入りに追加」
static NSString *const st_favoritesIdentifier			= @"AddFavorites";
static NSString *const st_favoritesLabelKey				= @"AddFavorites Label";
static NSString *const st_favoritesPaletteLabelKey		= @"AddFavorites Palette Label";
static NSString *const st_favoritesToolTipKey			= @"AddFavorites ToolTip";
static NSString *const st_favorites_imageName			= @"AddFavorites";

// 削除
static NSString *const st_deleteItemItemIdentifier			= @"Delete";
static NSString *const st_deleteItemItemLabelKey			= @"Delete Label";
static NSString *const st_deleteItemItemPaletteLabelKey		= @"Delete Palette Label";
static NSString *const st_deleteItemItemToolTipKey			= @"Delete ToolTip";
static NSString *const st_deleteItem_ImageName				= @"Delete";

// オンライン
static NSString *const st_onlineModeIdentifier			= @"OnlineMode";
static NSString *const st_onlineModeLabelKey			= @"OnlineMode Label";
static NSString *const st_onlineModePaletteLabelKey		= @"OnlineMode Palette Label";
static NSString *const st_onlineModeToolTipKey			= @"OnlineMode ToolTip";
static NSString *const st_onlineMode_ImageName			= @"online";

// Launch CMLogFinder (Removed in Twincam Angel.)
static NSString *const st_launchCMLFIdentifier			= @"Launch CMLF";

// 停止
static NSString *const st_stopTaskIdentifier			= @"stopTask";
static NSString *const st_stopTaskLabelKey				= @"stopTask Label";
static NSString *const st_stopTaskPaletteLabelKey		= @"stopTask Palette Label";
static NSString *const st_stopTaskToolTipKey			= @"stopTask ToolTip";
static NSString *const st_stopTask_ImageName			= @"stopSign";

// 戻る／進む
static NSString *const st_historySegmentedControlIdentifier			= @"historySC";	
static NSString *const st_historySegmentedControlLabelKey			= @"historySC Label";
static NSString *const st_historySegmentedControlPaletteLabelKey	= @"historySC Palette Label";

// 拡大／縮小
static NSString *const st_scaleSegmentedControlIdentifier			= @"scaleSC";	
static NSString *const st_scaleSegmentedControlLabelKey			= @"scaleSC Label";
static NSString *const st_scaleSegmentedControlPaletteLabelKey	= @"scaleSC Palette Label";

// ブラウザ
static NSString *const st_browserItemIdentifier			= @"Main Browser";
static NSString *const st_browserItemLabelKey			= @"Main Browser Label";
static NSString *const st_browserItemPaletteLabelKey	= @"Main Browser Palette Label";
static NSString *const st_browserItemToolTipKey			= @"Main Browser ToolTip";
static NSString *const st_browserItem_ImageName			= @"OrderFrontBrowser";

// アクション
/*static NSString *const st_actionButtonItemIdentifier    = @"ActionButton";
static NSString *const st_actionButtonItemLabelKey      = @"ActionButton Label";
static NSString *const st_actionButtonItemPaletteLabelKey = @"ActionButton Palette Label";*/

static NSString *const st_toolbar_identifier			= @"Thread Window Toolbar";


@implementation CMRThreadViewerTbDelegate
- (NSString *)identifier
{
	return st_toolbar_identifier;
}
@end



@implementation CMRThreadViewerTbDelegate(Private)
- (NSString *)reloadThreadItemIdentifier
{
	return st_reloadItem_Identifier;
}
- (NSString *)replyItemIdentifier
{
	return st_ReplyItem_Identifier;
}
- (NSString *)addFavoritesItemIdentifier
{
	return st_favoritesIdentifier;
}
- (NSString *)deleteItemIdentifier
{
	return st_deleteItemItemIdentifier;
}
- (NSString *)toggleOnlineModeIdentifier
{
	return st_onlineModeIdentifier;
}

- (NSString *)stopTaskIdentifier
{
	return st_stopTaskIdentifier;
}
- (NSString *)historySegmentedControlIdentifier
{
	return st_historySegmentedControlIdentifier;
}
- (NSString *)scaleSegmentedControlIdentifier
{
	return st_scaleSegmentedControlIdentifier;
}
- (NSString *)orderFrontBrowserItemIdentifier
{
	return st_browserItemIdentifier;
}
/*
- (NSString *)actionButtonItemIdentifier
{
    return st_actionButtonItemIdentifier;
}
*/
- (NSArray *)unsupportedItemsArray
{
	return [[super unsupportedItemsArray] arrayByAddingObject:st_launchCMLFIdentifier];
}
@end


@implementation CMRThreadViewerTbDelegate(Protected)
- (void)setupControl:(NSControl *)viewItem onItem:(NSToolbarItem *)tbItem action:(SEL)action target:(NSWindowController *)wc
{
    NSSize itemSize;
    [viewItem retain];
    [viewItem removeFromSuperviewWithoutNeedingDisplay];
    [viewItem setTarget:wc];
    [viewItem setAction:action];
    [tbItem setView:viewItem];
    [viewItem release];

    itemSize = [viewItem bounds].size;
    [tbItem setMinSize:itemSize];
    [tbItem setMaxSize:itemSize];

    [(BSSegmentedControlTbItem *)tbItem setDelegate:wc];
}
/*
- (void)setupActionButtonItem:(NSToolbarItem *)tbItem windowController:(id)wc
{
    NSSize itemSize;
    [m_actionButton retain];
    [m_actionButton removeFromSuperviewWithoutNeedingDisplay];
    [m_actionButton setTarget:nil];
    [m_actionButton setAction:NULL];
    [tbItem setView:m_actionButton];
    [m_actionButton release];
    
    itemSize = [m_actionButton bounds].size;
    [tbItem setMinSize:itemSize];
    [tbItem setMaxSize:itemSize];
    
//    [(BSSegmentedControlTbItem *)tbItem setDelegate:wc];
    [m_actionButton setMenu:[[wc class] loadContextualMenuForTextView]];
}
*/
- (void)initializeToolbarItems:(NSWindow *)aWindow
{
	NSToolbarItem			*item_;
	NSWindowController		*wcontroller_;

    BOOL loadNibSuccess = [NSBundle loadNibNamed:@"CMRThreadViewerTbItems" owner:self];
    NSAssert(loadNibSuccess, @"Fail to load CMRThreadViewerTbItems.nib!");
    
	wcontroller_ = [aWindow windowController];
	UTILAssertNotNil(wcontroller_);

	item_ = [self appendToolbarItemWithItemIdentifier:[self reloadThreadItemIdentifier]
									localizedLabelKey:st_reloadItem_LabelKey
							 localizedPaletteLabelKey:st_reloadItem_PaletteLabelKey
								  localizedToolTipKey:st_reloadItem_ToolTipKey
											   action:@selector(reloadThread:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_reloadThread_imageName]];

	item_ = [self appendToolbarItemWithItemIdentifier:[self replyItemIdentifier]
									localizedLabelKey:st_ReplyItem_LabelKey
							 localizedPaletteLabelKey:st_ReplyItem_PaletteLabelKey
								  localizedToolTipKey:st_ReplyItem_ToolTipKey
											   action:@selector(reply:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_ReplyItem_imageName]];

	item_ = [self appendToolbarItemWithItemIdentifier:st_favoritesIdentifier
									localizedLabelKey:st_favoritesLabelKey
							 localizedPaletteLabelKey:st_favoritesPaletteLabelKey
								  localizedToolTipKey:st_favoritesToolTipKey
											   action:@selector(addFavorites:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_favorites_imageName]];

	item_ = [self appendToolbarItemWithItemIdentifier:[self deleteItemIdentifier]
									localizedLabelKey:st_deleteItemItemLabelKey
							 localizedPaletteLabelKey:st_deleteItemItemPaletteLabelKey
								  localizedToolTipKey:st_deleteItemItemToolTipKey
											   action:@selector(deleteThread:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_deleteItem_ImageName]];

	item_ = [self appendToolbarItemWithItemIdentifier:[self toggleOnlineModeIdentifier]
									localizedLabelKey:st_onlineModeLabelKey
							 localizedPaletteLabelKey:st_onlineModePaletteLabelKey
								  localizedToolTipKey:st_onlineModeToolTipKey
											   action:@selector(toggleOnlineMode:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_onlineMode_ImageName]];

	item_ = [self appendToolbarItemWithItemIdentifier:[self stopTaskIdentifier]
									localizedLabelKey:st_stopTaskLabelKey
							 localizedPaletteLabelKey:st_stopTaskPaletteLabelKey
								  localizedToolTipKey:st_stopTaskToolTipKey
											   action:@selector(cancelCurrentTask:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_stopTask_ImageName]];
	
	item_ = [self appendToolbarItemWithItemIdentifier:[self orderFrontBrowserItemIdentifier]
									localizedLabelKey:st_browserItemLabelKey
							 localizedPaletteLabelKey:st_browserItemPaletteLabelKey
								  localizedToolTipKey:st_browserItemToolTipKey
											   action:@selector(showMainBrowser:)
											   target:nil];
	[item_ setImage:[NSImage imageAppNamed:st_browserItem_ImageName]];
	
	item_ = [self appendToolbarItemWithClass:[BSSegmentedControlTbItem class]
							  itemIdentifier:[self historySegmentedControlIdentifier]
						   localizedLabelKey:st_historySegmentedControlLabelKey
					localizedPaletteLabelKey:st_historySegmentedControlPaletteLabelKey
						 localizedToolTipKey:nil
									  action:NULL
									  target:wcontroller_];
    [self setupControl:m_historyButton onItem:item_ action:@selector(historySegmentedControlPushed:) target:wcontroller_];
	
	item_ = [self appendToolbarItemWithClass:[BSSegmentedControlTbItem class]
							  itemIdentifier:[self scaleSegmentedControlIdentifier]
						   localizedLabelKey:st_scaleSegmentedControlLabelKey
					localizedPaletteLabelKey:st_scaleSegmentedControlPaletteLabelKey
						 localizedToolTipKey:nil
									  action:NULL
									  target:wcontroller_];
    [self setupControl:m_scaleButton onItem:item_ action:@selector(scaleSegmentedControlPushed:) target:wcontroller_];
/*	
	item_ = [self appendToolbarItemWithItemIdentifier:[self actionButtonItemIdentifier]
						   localizedLabelKey:st_actionButtonItemLabelKey
					localizedPaletteLabelKey:st_actionButtonItemPaletteLabelKey
						 localizedToolTipKey:nil
									  action:NULL
									  target:wcontroller_];
    [self setupActionButtonItem:item_ windowController:wcontroller_];*/
}
@end



@implementation CMRThreadViewerTbDelegate(NSToolbarDelegate)
- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
				[self reloadThreadItemIdentifier],
				NSToolbarSeparatorItemIdentifier,
				[self deleteItemIdentifier],
				[self addFavoritesItemIdentifier],
				NSToolbarFlexibleSpaceItemIdentifier,
				[self orderFrontBrowserItemIdentifier],
				NSToolbarSeparatorItemIdentifier,
				[self replyItemIdentifier],
				nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
				[self reloadThreadItemIdentifier],
				[self stopTaskIdentifier],
				[self addFavoritesItemIdentifier],
				[self deleteItemIdentifier],
				[self replyItemIdentifier],
				[self toggleOnlineModeIdentifier],
				[self scaleSegmentedControlIdentifier],
				[self historySegmentedControlIdentifier],
				[self orderFrontBrowserItemIdentifier],
				NSToolbarSeparatorItemIdentifier,
				NSToolbarFlexibleSpaceItemIdentifier,
				NSToolbarSpaceItemIdentifier,
				nil];
}
@end
