//
//  BSDBThreadsListDBUpdateTask2.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 06/08/06.
//  Copyright 2006-2011 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSDBThreadsListDBUpdateTask2.h"

#import <CocoaOniguruma/OnigRegexp.h>

#import "CMRHostHandler.h"
#import "CMXTextParser.h"
#import "CMRDocumentFileManager.h"

#import "BSCoreDataManager.h"
#import "BSThreadInformationObject.h"
#import "BSThreadItemObject.h"
#import "BSBoardThreadItemsObject.h"


#define CHECK_DURATION 0

static inline id nilIfObjectIsNSNull(id obj)
{
	return (obj == [NSNull null]) ? nil : obj;
}

@implementation BSDBThreadsListDBUpdateTask2

static OnigRegexp *gRegexp = nil;

+ (NSString *)localizableStringsTableName
{
	return @"ThreadsList";
}
- (id)initWithBBSName:(NSString *)name data:(NSData *)data livedoor:(BOOL)isLivedoorFlag rebuilding:(BOOL)isRebuildingFlag
{
	if (self = [self initWithBBSName:name data:data]) {
/*		[self setBBSName:name];

		if (!boardID) {
			[self release];
			return nil;
		}*/
//        bbsName = [name retain];
//
//		subjectData = [data retain];
		isRebuilding = isRebuildingFlag;
        isLivedoor = isLivedoorFlag;
	}

	return self;
}

+ (id)taskWithBBSName:(NSString *)name data:(NSData *)data livedoor:(BOOL)isLivedoorFlag rebuilding:(BOOL)isRebuildingFlag
{
    return [[[self alloc] initWithBBSName:name data:data livedoor:isLivedoorFlag rebuilding:isRebuildingFlag] autorelease];
}

+ (id)taskWithBBSName:(NSString *)name data:(NSData *)data
{
	return [[[self alloc] initWithBBSName:name data:data] autorelease];
}

- (id)initWithBBSName:(NSString *)name data:(NSData *)data
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	
	NSNumber *aBoardID = [cdm boardIDFromBoardName:name];
	
	return [self initWithBoardID:aBoardID data:data];
}
+ (id)taskWithBoardID:(NSNumber *)inBoardID data:(NSData *)data
{
	return [[[self alloc] initWithBoardID:inBoardID data:data] autorelease];
}
- (id)initWithBoardID:(NSNumber *)inBoardID data:(NSData *)data
{
	[super init];
	[self setBoardID:inBoardID];
	subjectData = [data retain];
	isRebuilding = NO;
	isLivedoor = NO;
	
	if(!boardID) {
		[self release];
		return nil;
	}
	
	[self setIsInProgress:YES];
	[self setAmount:-1];
	
	return self;
}

- (BOOL)isRebuilding
{
	return isRebuilding;
}

/*- (void)setRebuilding:(BOOL)flag
{
	isRebuilding = flag;
}*/

- (BOOL)isLivedoor
{
    return isLivedoor;
}

/*- (void)setLivedoor:(BOOL)flag
{
    isLivedoor = flag;
}*/

- (NSError *)lastErrorWhileRebuilding
{
    return lastError;
}

- (void)dealloc
{
	[subjectData release];
	[boardID release];
	[bbsName release];
    [lastError release];

	[boardInformationObject release];
	
	[self deleteSurviveThreadItems];
	[surviveThreadItemsObject release];
	[sortedThreads release];
	
	[super dealloc];
}

- (void)setBoardID:(NSNumber *)inBoardID
{
	[boardID autorelease];
	boardID = [inBoardID retain];
	
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	bbsName = [[cdm boardNameFromBoardID:boardID] retain];
}

- (void)insertOrUpdateFromLogFiles:(NSError **)error
{
	NSString *folderPath = [[CMRDocumentFileManager defaultManager] directoryWithBoardName:bbsName];
	
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	[cdm rebuildFromLogFolder:folderPath boardID:boardID error:error];
}

- (BSBoardInformationObject *)boardInformationObject
{
	if(boardInformationObject) return boardInformationObject;
	
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	NSDictionary *hints = [NSDictionary dictionaryWithObject:boardID forKey:BSBoardInformationObjectHintID];
	boardInformationObject = [coreDataManager findBSBoardInformationObjectForHints:hints];
	
	return [boardInformationObject retain];
}
- (void)deleteSurviveThreadItems
{
	if(!surviveThreadItemsObject) return;
	[surviveThreadItemsObject.managedObjectContext deleteObject:surviveThreadItemsObject];
}

- (BSBoardThreadItemsObject *)surviveThreadItemsObject
{
	if(surviveThreadItemsObject) return surviveThreadItemsObject;
	
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	surviveThreadItemsObject = [NSEntityDescription insertNewObjectForEntityForName:BSCoreDataModelSurviveThreadItemsName
																inManagedObjectContext:coreDataManager.managedObjectContext];
	surviveThreadItemsObject.board = [self boardInformationObject];
	
	return [surviveThreadItemsObject retain];
}
- (void)prefetchThreadInformation
{
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	
	NSArray *sortDescriptors = [NSArray arrayWithObject:
								[[[NSSortDescriptor alloc] initWithKey:@"threadID" ascending:YES] autorelease]];
	NSArray *array = [coreDataManager fetchDataForEntityName:BSCoreDataModelThreadInformationName
											 sortDescriptors:sortDescriptors
											 predicateFormat:@"%K = %@", @"board", [self boardInformationObject]];
	
	sortedThreads = [[NSArray arrayWithArray:array] retain];
}

+ (BOOL)makeRegex
{
    if (!gRegexp) {
        gRegexp = [OnigRegexp compile:[NSString stringWithFormat:@"(\\d+)[^,<>]*(?:<>|,)(.*)\\s*(?:\\(|<>|%C)(\\d+)",0xFF08]];
        [gRegexp retain];
    }
    return YES;
}
CFComparisonResult searchFunction(const void *val1, const void *val2, void *context)
{
	NSString *obj1;
	NSString *obj2;
	
	if([(id)val1 isKindOfClass:[BSThreadInformationObject class]]) {
		BSThreadInformationObject *info = (id)val1;
		obj1 = info.threadID;
	} else {
		obj1 = (id)val1;
	}
	
	if([(id)val2 isKindOfClass:[BSThreadInformationObject class]]) {
		BSThreadInformationObject *info = (id)val2;
		obj2 = info.threadID;
	} else {
		obj2 = (id)val2;
	}
	
	return [obj1 compare:obj2];
}

- (BOOL)isnertOrUpdateThreadID:(NSString *)datString title:(NSString *)title count:(NSNumber *)count index:(NSNumber *)index
{
//	NSLog(@"Enter %s", __PRETTY_FUNCTION__);
//	NSLog(@"ThreadId ->\t%@\nTitle ->\t%@\nCount ->\t%@\nIndex ->\t%@", datString, title, count, index);
	
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	NSManagedObjectContext *context = coreDataManager.managedObjectContext;
		
	BSThreadInformationObject *thread = nil;
	CFIndex i = CFArrayBSearchValues((CFArrayRef)sortedThreads, CFRangeMake(0, [sortedThreads count]), datString, searchFunction, NULL);
	
	if(i < [sortedThreads count]) {
		thread = [sortedThreads objectAtIndex:i];
	}
	
	if(thread && [datString isEqualToString:thread.threadID]) {
//		NSLog(@"Found it");
		thread.numberOfAll = count;
	} else {
		thread = [NSEntityDescription insertNewObjectForEntityForName:BSCoreDataModelThreadInformationName
											   inManagedObjectContext:context];
		thread.threadName = title;
		thread.threadID = datString;
		thread.board = [self boardInformationObject];
		thread.numberOfAll = count;
		thread.threadStatus = [NSNumber numberWithInteger:ThreadNewCreatedStatus];
//		NSLog(@"Can not find it. Create Item(%@)", thread);
	}
	
	// ThreadItemの生成
	BSThreadItemObject *item = [NSEntityDescription insertNewObjectForEntityForName:BSCoreDataModelThreadItemName
															 inManagedObjectContext:context];
	item.thread = thread;
	item.index = index;
	
	// SurviveThreadItemsの生成と登録
	BSBoardThreadItemsObject *items = [self surviveThreadItemsObject];
	[items addItemsObject:item];
	
	return YES;
}
				 
//- (void)run
- (void)doExecuteWithLayout:(CMRThreadLayout *)layout
{
	NSString *str;
	NSArray *lines;
	NSUInteger count, i;
	NSString *line;
	NSString *datString;
	id title;
	NSString *numString;
//    static OnigRegexp *regex = nil;
	
	NSAutoreleasePool *pool01 = [[NSAutoreleasePool alloc] init];
	
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	[self setMessage:[self localizedString:@"Analyzeing DAT"]];
	[self setIsInProgress:YES];
	[self setAmount:-1];

	UTILDebugWrite(@"Start BSDBThreadsListDBUpdateTask2.");

	CFStringEncoding enc;
	NSString *urlStr;
	NSURL *url;
	CMRHostHandler *handler;

	urlStr = [coreDataManager urlStringFromBoardID:boardID];
	url = [NSURL URLWithString:urlStr];
	if (!url) {
		NSLog(@"Can NOT create url from bbs named %@.",bbsName);
		[pool01 release];
		return;
	}
	handler = [CMRHostHandler hostHandlerForURL:url];
	if (!handler) {
		NSLog(@"Can NOT create host handler from url %@.",url);
		[pool01 release];
		return;
	}
	enc = [handler subjectEncoding];
	str = [CMXTextParser stringWithData:subjectData CFEncoding:enc];
	// 行分割
	lines = [str componentsSeparatedByNewline];	

/*	if (!regex) {
		NSString *p = [NSString stringWithFormat:@"(\\d+)[^,<>]*(?:<>|,)(.*)\\s*(?:\\(|<>|%C)(\\d+)",0xFF08];
        regex = [[OnigRegexp compile:p] retain];
	}*/
    if (![[self class] makeRegex]) {
        UTILDebugWrite(@"Can not create regular expression(BSDBThreadsListDBUpdateTask2.)");
        goto final;
    }
    OnigResult *match;
	
#if CHECK_DURATION
	NSDate *date01 = [NSDate dateWithTimeIntervalSinceNow:0.0];
	NSDate *date02 = nil;
	NSDate *date03 = nil;
	NSDate *date04 = nil;
	NSDate *date05 = nil;
#endif
	// CoreData SurviveThreadItems をクリア
	[self deleteSurviveThreadItems];
	[self prefetchThreadInformation];
#if CHECK_DURATION
	date02 = [NSDate dateWithTimeIntervalSinceNow:0.0];
#endif
	
	[self checkIsInterrupted];
	
	UTILDebugWrite(@"START REGISTER THREADS");
	[self setMessage:[self localizedString:@"Resistering Thread"]];
	[self setAmount:0];
	
	count = [lines count];
	NSMutableSet *dats = isLivedoor ? [[NSMutableSet alloc] initWithCapacity:count] : nil;
	for (i = 0; i < count; i++) {
		if (isInterrupted) {
                [dats release];
                goto final;
			}
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		
		[self setAmount:i/(CGFloat)count * 100.0];
		
		line = [lines objectAtIndex:i];
		match = [gRegexp search:line];
		
		datString = [match stringAt:1];
		title = [match stringAt:2];
		numString = [match stringAt:3];
		
		if (!numString) {
			[pool release];
			continue;
		}
		if (isLivedoor) {
			if ([dats member:datString]) {
				[pool release];
				continue;
			} else {
				[dats addObject:datString];
			}
		}
		title = [[title mutableCopy] autorelease];
		[CMXTextParser replaceEntityReferenceWithString:title];
		
		// CoreDataに投入
		[self isnertOrUpdateThreadID:datString
							   title:title
							   count:[NSNumber numberWithUnsignedInteger:[numString integerValue]]
							   index:[NSNumber numberWithUnsignedInteger:i+1]];
		[pool release];
	}
	[dats release];
	
	UTILDebugWrite(@"END REGISTER THREADS");
#if CHECK_DURATION
	date03 = [NSDate dateWithTimeIntervalSinceNow:0.0];
#endif
	
	[self setIsInProgress:NO];
	[self setAmount:-1];
	[self setMessage:@""];
	if (isInterrupted) goto final;
	
	[self setIsInProgress:YES];
	if (isRebuilding) {
		[self setMessage:[self localizedString:@"Rebuilding Board"]];
		
		NSError *error = nil;
		[self insertOrUpdateFromLogFiles:&error];
		if (error) {
            lastError = [error retain];
        }
//		isRebuilding = NO;
	} else {
		[self setMessage:[self localizedString:@"Deleting Unused items"]];
		BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
		[cdm deleteUnusedInfomationsOnBoardID:boardID];
	}
	
final:
	[sortedThreads release];
	sortedThreads = nil;
	[boardInformationObject release];
	boardInformationObject = nil;
	[surviveThreadItemsObject release];
	surviveThreadItemsObject = nil;
	
#if CHECK_DURATION
	date04 = [NSDate dateWithTimeIntervalSinceNow:0.0];
#endif
	[self setMessage:[self localizedString:@"Saving changes"]];
	[coreDataManager saveAction:nil];
#if CHECK_DURATION
	date05 = [NSDate dateWithTimeIntervalSinceNow:0.0];
#endif
	
#if CHECK_DURATION
	NSTimeInterval prepareTime = [date02 timeIntervalSinceDate:date01];
	NSTimeInterval resisiterTime = [date03 timeIntervalSinceDate:date02];
	NSTimeInterval rebuildOrDeleteTime = [date04 timeIntervalSinceDate:date03];
	NSTimeInterval saveTime = [date05 timeIntervalSinceDate:date04];
	NSTimeInterval allTime = [date05 timeIntervalSinceDate:date01];
	NSLog(@"\nAll:\t%.3f\n"
		  "prepare:\t%.3f\n"
		  "resister:\t%.3f\n"
		  "delete:\t%.3f\n"
		  "save:\t%.3f\n"
		  "Save Retio:\t%.3f\n",
		  allTime, prepareTime, resisiterTime, rebuildOrDeleteTime, saveTime, saveTime/allTime*100);
#endif
	[pool01 release];
	
	return;
}

@end
