/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


function b2rAboneManager(){
	this._init();
}

b2rAboneManager.prototype = {

	get ABONE_TYPE_NAME(){ return Ci.b2rIAboneManager.ABONE_TYPE_NAME },
	get ABONE_TYPE_MAIL(){ return Ci.b2rIAboneManager.ABONE_TYPE_MAIL },
	get ABONE_TYPE_ID  (){ return Ci.b2rIAboneManager.ABONE_TYPE_ID   },
	get ABONE_TYPE_WORD(){ return Ci.b2rIAboneManager.ABONE_TYPE_WORD },

	_init: function(){
		this._loadAboneData();
	},

	_loadAboneData: function(){
		this._aboneData = new Array();
		this._aboneData["name"] = this._loadNgFile("NGnames.txt");
		this._aboneData["mail"] = this._loadNgFile("NGaddrs.txt");
		this._aboneData["id"] = this._loadNgFile("NGid.txt");
		this._aboneData["word"] = this._loadNgFile("NGwords.txt");
	},
	_loadNgFile: function(aNgFileName){
		var ngFile = gGlobalService.io.getDataDir();
		ngFile.appendRelativePath(aNgFileName);
		if(!ngFile.exists()) return new Array();

		var resultArray = new Array();
		var fileInputStream = XPC.createInstance("@mozilla.org/network/file-input-stream;1",
			"nsIFileInputStream");
		fileInputStream.init(ngFile, 0x01, 0666, 0);
		fileInputStream.QueryInterface(Ci.nsILineInputStream);
		let(more, line = {}){
			do{
				more = fileInputStream.readLine(line);
				if(line.value) resultArray.push(line.value);
			}while(more);
		}
		fileInputStream.close();
		return resultArray;
	},


	_saveAboneData: function(){
		this._saveNgFile("NGnames.txt", this._aboneData["name"]);
		this._saveNgFile("NGaddrs.txt", this._aboneData["mail"]);
		this._saveNgFile("NGid.txt", this._aboneData["id"]);
		this._saveNgFile("NGwords.txt", this._aboneData["word"]);
	},
	_saveNgFile: function(aNgFileName, aboneDataArray){
		var ngFile = gGlobalService.io.getDataDir();
		ngFile.appendRelativePath(aNgFileName);
			// nsILocalFile.create は親フォルダをふくめて作成する
		if(!ngFile.exists()) ngFile.create(Ci.nsILocalFile.NORMAL_FILE_TYPE, 0666);

		var content = aboneDataArray.join("\n");

		var fileOutputStream = XPC.createInstance("@mozilla.org/network/file-output-stream;1",
				"nsIFileOutputStream");
			// 0x02=PR_WRONLY; 0x08=PR_CREATE_FILE;
			// 0x10=PR_APPEND; 0x20=PR_TRUNCATE;
		fileOutputStream.init(ngFile, 0x02|0x08|0x20, 0666, 0);
		fileOutputStream.write(content, content.length);
		fileOutputStream.flush();
		fileOutputStream.close();
	},


	shouldAbone: function(aName, aMail, aID, aMsg){
		function checkFunc(aElement, aIndex, aArray){
			return this.indexOf(aElement) != -1;
		}
		if(aName && this._aboneData["name"].some(checkFunc, aName)) return true;
		if(aMail && this._aboneData["mail"].some(checkFunc, aMail)) return true;
		if(aID && this._aboneData["id"].some(checkFunc, aID)) return true;
		if(aMsg && this._aboneData["word"].some(checkFunc, aMsg)) return true;

		return false;
	},


	getAboneData: function(aType){
		var ngArray;
		switch(aType){
			case this.ABONE_TYPE_NAME:
				ngArray = this._aboneData["name"];
				break;
			case this.ABONE_TYPE_MAIL:
				ngArray = this._aboneData["mail"];
				break;
			case this.ABONE_TYPE_ID:
				ngArray = this._aboneData["id"];
				break;
			case this.ABONE_TYPE_WORD:
				ngArray = this._aboneData["word"];
				break;
			default:
				return null;
		}

		var unicodeConverter = XPC.createInstance("@mozilla.org/intl/scriptableunicodeconverter",
				"nsIScriptableUnicodeConverter");
		unicodeConverter.charset = "Shift_JIS";

		var resultArray = ngArray.map(function testFunc(aElement, aIndex, aArray){
				return unicodeConverter.ConvertToUnicode(aElement);
		});
		return resultArray;
	},


	addAbone: function(aWord, aType){
		var unicodeConverter = XPC.createInstance("@mozilla.org/intl/scriptableunicodeconverter",
				"nsIScriptableUnicodeConverter");
		unicodeConverter.charset = "Shift_JIS";

		var sjisWord = unicodeConverter.ConvertFromUnicode(aWord);

		var ngArray;
		switch(aType){
			case this.ABONE_TYPE_NAME:
				ngArray = this._aboneData["name"];
				break;
			case this.ABONE_TYPE_MAIL:
				ngArray = this._aboneData["mail"];
				break;
			case this.ABONE_TYPE_ID:
				ngArray = this._aboneData["id"];
				break;
			case this.ABONE_TYPE_WORD:
				ngArray = this._aboneData["word"];
				break;
			default:
				return;
		}

			// 二重登録の禁止
		if(ngArray.indexOf(sjisWord) != -1) return;

		ngArray.push(sjisWord);

		var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
		var type = XPC.createInstance("@mozilla.org/supports-PRInt32;1", "nsISupportsPRInt32");
		type.data = aType;

		os.notifyObservers(type, "b2r-abone-data-add", aWord);
	},


	removeAbone: function(aWord, aType){
		var unicodeConverter = XPC.createInstance("@mozilla.org/intl/scriptableunicodeconverter",
				"nsIScriptableUnicodeConverter");
		unicodeConverter.charset = "Shift_JIS";

		var sjisWord = unicodeConverter.ConvertFromUnicode(aWord);

		var ngArray;
		switch(aType){
			case this.ABONE_TYPE_NAME:
				ngArray = this._aboneData["name"];
				break;
			case this.ABONE_TYPE_MAIL:
				ngArray = this._aboneData["mail"];
				break;
			case this.ABONE_TYPE_ID:
				ngArray = this._aboneData["id"];
				break;
			case this.ABONE_TYPE_WORD:
				ngArray = this._aboneData["word"];
				break;
			default:
				return;
		}

		var wordIndex = ngArray.indexOf(sjisWord);
		if(wordIndex != -1) ngArray.splice(wordIndex, 1);

		var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
		var type = XPC.createInstance("@mozilla.org/supports-PRInt32;1", "nsISupportsPRInt32");
		type.data = aType;
		os.notifyObservers(type, "b2r-abone-data-remove", aWord);
	}

};