/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * m2ts.c
 * Copyright (C) Koichi Akabe 2009 <mail@vbkaisetsu.com>
 * 
 * m2ts.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * m2ts.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "m2ts.h"

// M2TS decoding program

long peslength[8192];
char **m2tsStream;
char dataf[8192];
unsigned long pos[8192];

// initializer (you should call this function first)
int m2tsInitialize()
{
	int i;
	for(i = 0; i < 8192; i++)
	{
		dataf[i] = 0;
		peslength[i] = 0;
	}
	free(m2tsStream);
	m2tsStream = (char**)malloc(8192 * sizeof(char*));
	
	return 0;
}

int m2tsReset()
{
	int i;
	for(i = 0; i < 8192; i++)
	{
		peslength[i] = 0;
		pos[i] = 0;
	}
	return 0;
}

// sprit and build packets
char* get_m2tsStreamData(int pid, long *len)
{
	*len = pos[pid];
	return m2tsStream[pid];
}

// read 192byte packets
int m2tsSet192Data(char data[], int *pid, long *length, int *proc_pid)
{
	unsigned char sid;
	char af_ctrl;
	unsigned char af_count;
	unsigned char pes_headlength;
	unsigned char fpflag = 0;
	char *datapf = data;
	unsigned long ats;
	int m2tsPid;
	int i;
	ats  = (unsigned char)data[0] << 24;
	ats |= (unsigned char)data[1] << 16;
	ats |= (unsigned char)data[2] << 8;
	ats |= (unsigned char)data[3];
	if(data[4] != 0x47)
		return -3;
	m2tsPid = (unsigned char)(data[5] & 0x1f) << 8;
	m2tsPid |= (unsigned char)data[6];
	
	for(i = 0; i < 4; i++)
	{
		if(proc_pid[i] == m2tsPid)
		{
			goto proc;
		}
	}
	return -4;
proc:
	if(data[5] & 0x40) // first data
	{
		if(peslength[m2tsPid] < 0)
		{
			peslength[m2tsPid] = 0;
			*pid = m2tsPid;
			return -5;
		}
		pos[m2tsPid] = 0;
		fpflag = 1;
	}
	af_ctrl = (data[7] & 0xf0) >> 4;
	if(af_ctrl == 2)
		return -1;
	if(af_ctrl == 3)
	{
		af_count = data[8] + 1;
		data += af_count;
	}
	if(fpflag)
	{
		if(data[8] == 0 && data[9] == 0 && data[10] == 1) // first data --> PES header?
		{
			sid = data[11];
			peslength[m2tsPid]  = ((unsigned char)data[12] << 8) & 0xff00;
			peslength[m2tsPid] |= (unsigned char)data[13];
			pes_headlength = data[16];
			peslength[m2tsPid] -= pes_headlength + 3;
			data += pes_headlength + 9;
		}
		else
		{
			peslength[m2tsPid] = 1048576;
		}
	}
	if(dataf[m2tsPid] == 0)
	{
		if(fpflag == 0)
		{
			peslength[m2tsPid] = 1048576;
		}
		m2tsStream[m2tsPid] = malloc(1048576 * sizeof(char));
		dataf[m2tsPid] = 1;
	}
	data += 8;
	//printf("%d, %d\n", pos[m2tsPid], 192 + datapf - data);
	memcpy(m2tsStream[m2tsPid] + pos[m2tsPid], data, 192 + datapf - data);
	pos[m2tsPid] += 192 + datapf - data;
	*pid = m2tsPid;
	*length = peslength[m2tsPid];
	if(pos[m2tsPid] == peslength[m2tsPid])
		return 0;
	if(fpflag == 1)
		return -2;
	if(pos[m2tsPid] < peslength[m2tsPid] || peslength[m2tsPid] < 0)
		return -1;
	return -3;
}
