/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $ */
static char rcsid[] = "@(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $";

/*
 * $Log: virtual_memory.c,v $
 * Revision 1.1  2011/12/27 17:13:36  liu1
 * Initial Version.
 *
 * Revision 1.12  1996-01-06 16:08:03  night
 * ƤӽФؿְ̾äƤΤľ
 *
 * Revision 1.11  1995/12/13 15:02:23  night
 * vmap_reg() ؿȤ
 *
 * Revision 1.10  1995/09/21  15:51:29  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.9  1995/09/17  17:00:12  night
 * ;ʬ printf ()  #ifdef notdef ... #endif ǰϤ
 *
 * Revision 1.8  1995/09/14  04:33:09  night
 * ɥ쥹ޥѤͤѹ
 *
 * Revision 1.7  1995/05/31  22:58:00  night
 * Ĥ #ifdef DEBUG ... #endif ɲá
 * (;ʬʥǥХå printf ʸΥ)
 *
 * Revision 1.6  1995/03/18  14:50:11  night
 * vcre_reg() ؿ򥳥ѥǤ褦˽
 *
 * Revision 1.5  1995/02/26  14:07:40  night
 * RCS ޥ $Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $  $Log: virtual_memory.c,v $
 * RCS ޥ $Header: /home/night/CVS/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.12 1996-01-06 16:08:03 night Exp $  Revision 1.1  2011/12/27 17:13:36  liu1
 * RCS ޥ $Header: /home/night/CVS/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.12 1996-01-06 16:08:03 night Exp $  Initial Version.
 * RCS ޥ $Header: /home/night/CVS/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.12 1996-01-06 16:08:03 night Exp $ 
 * RCS ޥ $Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $  Revision 1.11  1995/12/13 15:02:23  night
 * RCS ޥ $Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $  vmap_reg() ؿȤ
 * RCS ޥ $Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/itron-3.0/i386/virtual_memory.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $ 
 * Revision 1.10  1995/09/21  15:51:29  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.9  1995/09/17  17:00:12  night
 * ;ʬ printf ()  #ifdef notdef ... #endif ǰϤ
 *
 * Revision 1.8  1995/09/14  04:33:09  night
 * ɥ쥹ޥѤͤѹ
 *
 * Revision 1.7  1995/05/31  22:58:00  night
 * Ĥ #ifdef DEBUG ... #endif ɲá
 * (;ʬʥǥХå printf ʸΥ)
 *
 * Revision 1.6  1995/03/18  14:50:11  night
 * vcre_reg() ؿ򥳥ѥǤ褦˽
 * ɲá
 *
 *
 */

/* virtual_memory.c
 *	
 *
 */

#include "i386.h"
#include "itron.h"
#include "misc.h"
#include "func.h"
#include "task.h"
#include "errno.h"
#include "region.h"

static I386_PAGE_ENTRY *alloc_pagetable (void);

/* #define DEBUG	1	/* */


/* dup_vmap_table --- ꤵ줿ۥΥޥåԥ󥰥ơ֥
 *		      ԡ롣
 *		      ޥåץơ֥뼫ΤϿ롣
 *
 */
ADDR_MAP 
dup_vmap_table (ADDR_MAP dest)
{
  ADDR_MAP	newp;
  int		i;
  I386_PAGE_ENTRY	*p;


  (UW)dest = (UW)dest | 0x80000000;
  newp = (ADDR_MAP)(palloc (1));	/* ڡǥ쥯ȥΥ */
  for (i = 0; i < ADDR_MAP_SIZE; i++)
    {
      newp[i] = dest[i];		/* ڡǥ쥯ȥ򣱥ȥꤺĥԡ */
      if (newp[i].present)		/* ȥ꤬ޥåԥ󥰤ƤʤС   */
	{				/* ԡ롣                             */
	  p = (I386_PAGE_ENTRY *)(palloc (1));
	  bcopy ((VP)RTOV(dest[i].frame_addr << PAGE_SHIFT), (VP)p, PAGE_SIZE);
#ifdef notdef
	  printf ("dup_vmap_table: [%d]copy 0x%x -> 0x%x\n", 
		  i,
		  (VP)RTOV(dest[i].frame_addr << PAGE_SHIFT), 
		  (VP)p);
#endif /* notdef */
	  newp[i].frame_addr = ((UW)p & 0x7fffffff) >> PAGE_SHIFT;
	}
    }
  return (newp);
}

/***********************************************************************
 * release_vmap --- ꤷɥ쥹ޥåץơ֥򤹤٤Ʋ롣
 *
 */
extern ER
release_vmap (ADDR_MAP dest)
{
  I386_PAGE_ENTRY	*p;
  W			i;

  for (i = 0; i < ADDR_MAP_SIZE; i++)
    {
      (UW)p = (dest[i].frame_addr << PAGE_SHIFT) | 0x80000000;
      pfree (p, PAGE_SIZE);
    }
  pfree (dest, PAGE_SIZE);
}


/*************************************************************************
 * vmap --- ۥΥޥåԥ
 *
 * 	task	ޥåԥ󥰤оݤȤʤ륿
 *		vpage	ۥꥢɥ쥹
 *		ppage	ʪꥢɥ쥹
 *
 * ͡	TRUE	
 *		FALSE	
 *
 * 	ǻꤵ줿ۥʪ˳Ƥ
 *
 */
BOOL
vmap (T_TCB *task, UW vpage, UW ppage)
{
  I386_DIRECTORY_ENTRY	*dirent;
  I386_PAGE_ENTRY	*pageent;
  UW			dirindex;
  UW			pageindex;

#ifdef DEBUG
  printf ("[%d] vmap: 0x%x -> 0x%x\n", task->tskid, ppage, vpage);
#endif /* DEBUG */
/*  task->context.cr3 &= 0x7fffffff; */
  dirent = (I386_DIRECTORY_ENTRY *)(task->context.cr3);
  ((UW)dirent) |= 0x80000000;
  dirindex = vpage & 0xffc00000;
  dirindex = dirindex >> DIR_SHIFT;
  pageindex = (vpage & 0x003ff000) >> PAGE_SHIFT;

/*
  dirindex = vpage / (PAGE_SIZE * PAGE_SIZE);
*/
/*
  pageindex = (vpage % (PAGE_SIZE * PAGE_SIZE * PAGE_SIZE));
*/

#ifdef DEBUG
  printf ("dirindex = %d, pageindex = %d\n", dirindex, pageindex);
#endif /* DEBUG */
  if (dirent[dirindex].present != 1)
    {
      /* ڡǥ쥯ȥΥȥ϶ä
       * ڡǥ쥯ȥΥȥ롣
       */
      pageent = (I386_PAGE_ENTRY *)alloc_pagetable ();
      if (pageent == NULL)
	{
	  return (FALSE);
	}
#ifdef DEBUG
      printf ("dir alloc(newp). frame = 0x%x ", ((UW)pageent & 0x0fffffff) >> PAGE_SHIFT);
#endif /* DEBUG */
      dirent[dirindex].frame_addr = ((UW)pageent & 0x0fffffff) >> PAGE_SHIFT;
      dirent[dirindex].present = 1;
      dirent[dirindex].read_write = 1;
      dirent[dirindex].u_and_s = 1;
      dirent[dirindex].zero2 = 0;
      dirent[dirindex].access = 0;
      dirent[dirindex].dirty = 0;
      dirent[dirindex].user = 0;
      dirent[dirindex].zero1 = 0;
    }
  else
    {
      pageent = (I386_PAGE_ENTRY *)(dirent[dirindex].frame_addr * PAGE_SIZE);
#ifdef DEBUG
      printf ("dir alloc(old). frame = 0x%x ", dirent[dirindex].frame_addr);
#endif /* DEBUG */
    }

  pageent[pageindex].frame_addr = (ppage / PAGE_SIZE) & 0x7fffffff;
  pageent[pageindex].present = 1;
  pageent[pageindex].read_write = 1;
  pageent[pageindex].u_and_s = 1;
  pageent[pageindex].zero2 = 0;
  pageent[pageindex].access = 0;
  pageent[pageindex].dirty = 0;
  pageent[pageindex].zero1 = 0;
  pageent[pageindex].user = 0;
/*
  pageent[pageindex + 1].present = 1;
  pageent[pageindex + 1].read_write = 1;
  pageent[pageindex + 1].u_and_s = 1;

  pageent[pageindex + 31].present = 1;
  pageent[pageindex + 31].read_write = 1;
  pageent[pageindex + 31].u_and_s = 1;

  pageent[pageindex + 32].present = 1;
  pageent[pageindex + 32].read_write = 1;
  pageent[pageindex + 32].u_and_s = 1;

  pageent[pageindex + 33].present = 1;
  pageent[pageindex + 33].read_write = 1;
  pageent[pageindex + 33].u_and_s = 1;
*/
#ifdef DEBUG
  printf ("pageindex = %d, frame = 0x%x\n", pageindex, pageent[pageindex].frame_addr);
#endif /* DEBUG */
  return (TRUE);
}

/*
 *
 */
extern ER
vunmap (UW virtual)
{

}



/*************************************************************************
 * alloc_dirent --- ڡǥ쥯ȥơ֥κ
 *
 * 
 *
 * ͡
 *
 * 
 *
 */
static I386_PAGE_ENTRY *
alloc_pagetable (void)
{
  I386_PAGE_ENTRY	*newp;
  W			i;

  newp = (I386_PAGE_ENTRY *)palloc (1);
  if (newp == NULL)
    {
      return (NULL);
    }
  bzero (newp, PAGE_SIZE);
  for (i = 0; i < PAGE_SIZE / sizeof (I386_PAGE_ENTRY); i++)
    {
      newp[i].present = 0;
      newp[i].read_write = 1;
      newp[i].u_and_s = 1;
      newp[i].zero2 = 0;
      newp[i].access = 0;
      newp[i].dirty = 0;
      newp[i].user = 0;
      newp[i].zero1 = 0;
      newp[i].frame_addr = 0;
    }
  return (newp);
}


/*
 * ꡼κ
 *
 * ƥϡ꡼äƤ롣
 * ǻȤäƤʤȥӡǻꤷ롣
 *
 * δؿǤϡʪޥåԥ󥰤褦ʽϤʤ
 * ñ˿꡼ҤȤĳƤǤ롣
 * ⤷꡼ȤʪƤȤˤϡ
 * vcre_reg ¹ԤȤ vmap_reg ¹Ԥɬפ롣
 *
 */
ER
vcre_reg (ID	id, 	/* task ID */
	  VP	start,	/* ꡼γϥɥ쥹 */
	  W	min,	/* ꡼κǾ() */
	  W	max,	/* ꡼κ祵 */
	  UW	perm,	/* ꡼Υѡߥå */
	  FP	handle)	/* ꡼ǥڡեȤȯ */
			/* νλ */
{
  T_TCB		*taskp;
  T_REGION	*regp;
  W		counter;

  /*
   * ΥåԤ
   * ⤷ͤˤϡE_PAR Υ顼ֹ֤
   */
  if (start <= 0)	return (E_PAR);
  if (min <= 0)		return (E_PAR);
  if (max <= 0)		return (E_PAR);
  if (min > max)	return (E_PAR);

  /*
   *  ID 鳺륿ΥƥȤؤ
   * ݥ󥿤Ф
   */
  taskp = get_tskp (id);
  if (taskp == NULL)
    {
      /*
       * ǻꤷ ID ĥ¸ߤƤʤ
       * E_OBJ ֤
       */
      return (E_OBJ);
    }

  /*
   * ФΥƥȾ󤫤꡼Υȥ
   * Ф 
   */
  for (counter = 0; counter < MAX_REGION; counter++)
    {
      if (taskp->regions[counter].permission == 0)
	{
	  break;
	}
    }
  if (counter == MAX_REGION)
    {
      /*
       * Ƥ꡼󤬤ʤä
       * E_NOMEM Υ顼֤
       */
      return (E_NOMEM);
    }
  regp = &(taskp->regions[counter]);	/* regp ˶Ƥ꡼ */
					/* ȥݥ󥿤롣*/

  /*
   * ꡼ꡣ
   * ꡼󥨥ȥؤϡͤ򤽤Τޤ줺˰ʲΤ褦ʽ
   * Ԥ
   *	start		ڡڤΤƤ
   *	min_size	ڡڤ夲
   *	max_size	ڡڤ夲
   *	permission	Τޤ
   *	handle		Τޤ
   */
  regp->start_addr = (VP)CUTDOWN (start, PAGE_SIZE);
  regp->min_size = ROUNDUP (min, PAGE_SIZE);
  regp->max_size = ROUNDUP (max, PAGE_SIZE);
  regp->permission = perm;
  regp->handle = handle;
  
  /*
   * ˽λ
   */
  return (E_OK);
}

/*
 * ꡼˴
 *
 *  start ǻꤷɥ쥹ΰ꡼롣 
 * ꡼˴ޤޤΰΥǡ˴롣
 *
 * start ͤǻꤷɥ쥹ϡ꡼Ƭɥ쥹Ǥɬ
 * Ϥʤ꡼Υɥ쥹ʤСɤΥ꡼ꤷ
 * ƥॳȽǤ롣
 *
 */
ER
vdel_reg (ID id, VP start) 
     /* id     ꡼ĥ
      * start  ꡼Ƭɥ쥹
      */
{
  return (E_NOSPT);
}

/*
 * ꡼βۥڡʪդ롣
 *
 * ǻꤷɥ쥹ΰʪդ롣
 *
 * ʣΥڡ륵ꤵ줿硢ƤΥڡޥå
 * ǽΤȤΤʪդ롣¾ξϳդʤ
 *
 * ޥåפʪΥɥ쥹ϻǤʤ濴ˤۥ
 * դʪŬ˳꿶롣
 *
 *
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *	E_OK     ꡼Υޥåפ  
 *	E_NOMEM  (ʪ)꤬­Ƥ
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ롣
 *	E_PAR	 
 *
 */
ER
vmap_reg (ID id, VP start, UW size)
     /* 
      * id         ID
      * start     ޥåפ벾ۥΰƬɥ쥹
      * size      ޥåפ벾ۥΰ礭(Хñ)
      */
{
  T_TCB	*taskp;
  UW	counter;
  VP	pmem;

  taskp = (T_TCB *)get_tskp (id);
  if ((taskp->tskstat == TTS_NON) || (taskp->tskstat == TTS_DMT))
    {
      return (E_PAR);
    }

  size = ROUNDUP (size, PAGE_SIZE);
  (UW)start = ((UW)start / PAGE_SIZE) * PAGE_SIZE;
  for (counter = 0; counter < (size / PAGE_SIZE); counter++)
    {
      pmem = palloc (1);
      if (pmem == NULL)
	return (E_NOMEM);

      vmap (taskp, (UW)(counter + start), (UW)pmem);
    }
  return (E_OK);
}

/*
 * ꤷΤĥ꡼ʣ롣
 *
 * ʣ꡼ϡ̤ΤΤȤư롣
 * src, dst Τɤ餫Υ꡼ΰѹƤ⡢⤦
 * Υϱƶʤ
 *
 */
ER
vdup_reg (ID src, ID dst, VP start)
     /* src    ʣ꡼ĥ
      * dst    ꡼ʣΥ
      * start  ʣ꡼Ƭɥ쥹
      */
{
  return (E_NOSPT);
}

/*
 * ꡼˴ޤޤ뤹٤ƤβۥڡΥץƥȾꤹ롣
 *
 * ץƥȾȤƤϰʲͤǤ롣
 *
 *	VPROT_READ    ɤ߹߲ǽ
 *	VPROT_WRITE   񤭹߲ǽ
 *	VPROT_EXEC    ¹Բǽ
 *
 *
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *	E_OK     ꡼Υޥåפ  
 *	E_NOMEM  (ʪ)꤬­Ƥ
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ롣
 *	E_OK     ꡼ΥץƥȾ  
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ롣
 */
ER
vprt_reg (ID id, VP start, UW prot)
     /* id     ꡼ĥ
      * start  ꡼Ƭۥɥ쥹
      * prot   ץƥȾ
      */
{
  return (E_NOSPT);
}

/*
 * ֤ǤΥ꡼ζͭ
 *
 *  src ǻꤷΤĥ꡼ dst ǻꤷ
 * ˳Ƥ롣ꤢƤ꡼϶ͭ롣
 *
 * ͭ줿꡼˴ޤޤ벾ۥɥ쥹ΰˤϡ֤Ʊ
 * ʪɥ쥹Ƥ롣ΤᡢΥۥɥ쥹ΰ
 * ξѹ硢¾ΥˤȿǤ롣
 *
 *
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *
 *	E_OK     ꡼ζͭ  
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ롣
 *
 */
ER
vshr_reg (ID src, ID dst, VP start)
     /*
      * src    ͭΥ꡼ĥ
      * dst    ˥꡼ͭ륿
      * start  ꡼Ƭɥ쥹
      */
     
{
  return (E_NOSPT);
}

/*
 * ꡼󤫤ɤ߹
 *
 * ǤդΥβۥΰ褫ǡɤ߹ࡣ
 * ڡȤʤɤ˻Ѥ롣
 *
 *
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *
 *	E_OK       
 *	E_ID     ꡼ĥ
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ
 *
 */
ER
vget_reg (ID id, VP start, UW size, VP buf) 
     /*
      * id     ꡼ĥ
      * start  ɤ߹ΰƬɥ쥹
      * size   ꡼󤫤ɤ߹ॵ
      * buf    ꡼󤫤ɤ߹ǡХåե
      */
{
  return (E_NOSPT);
}

/*
 * ꡼ؤν񤭹
 *
 * ǤդΥβۥΰ˥ǡ񤭹ࡣ
 * ڡʤɤ˻ѤǤ롣
 *
 *
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *
 *	E_OK     ꡼ؤν񤭹ߤ  
 *	E_ID      id б¸ߤʤ
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ
 *
 */
ER
vput_reg (ID id, VP start, UW size, VP buf)
     /*
      * id     ꡼ĥ
      * start  񤭹ΰƬɥ쥹
      * size   ꡼˽񤭹ॵ
      * buf    ꡼˽񤭹ǡ
      */
{
  return (E_NOSPT);
}

/*
 * ꡼ξ롣
 *
 * ꡼ȤƤϼΤΤͤ롣
 *
 *	꡼Ƭۥɥ쥹
 *	꡼Υ
 *	ץƥȾ
 * 
 * ֤
 *
 * ʲΥ顼ֹ椬֤롣
 *
 *	E_OK     ꡼ξμ  
 *	E_ID      id ǻꤷ¸ߤʤ
 *	E_NOSPT  ܥƥॳϡ̤ݡȵǽǤ
 *
 */
ER
vsts_reg (id, start, stat)
     /*
      * id     ꡼ĥ
      * start  ꡼Ƭɥ쥹
      * stat   ꡼(꡼ξܺ٤̤Ǥ) 
      */
{
  return (E_NOSPT);
}

