/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/posix/usr/include/server/file.h,v 1.1 2011/12/27 17:13:36 liu1 Exp $ */

/*
 * $Log: file.h,v $
 * Revision 1.1  2011/12/27 17:13:36  liu1
 * Initial Version.
 *
 * Revision 1.3  1996-01-06 16:12:58  night
 * إåեΥ󥯥롼ɥѥѹ
 *
 * Revision 1.2  1995/09/21  15:51:58  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.1  1995/08/27  10:47:57  night
 * ǽϿ
 *
 *
 */


#ifndef __SERVER_FILE_H__
#define __SERVER_FILE_H__	1

#include "../../../../kernel/kernlib/message.h"
#include <sys/types.h>
#include <limits.h>

/*
 * եޥ͡㤬ݡȥޥ͡ϿȤ
 * Ѥ̾
 */
#define POSIX_FILE_SERVER	"posix.server.file"


/*
 * եޥ͡ꥯ
 */
enum file_request
{
  FILE_NULL,		/* ⤷ʤ 				*/
  FILE_ACCESS,		/* եΥå	*/
  FILE_LOOKUP,		/* ѥ̾é 			*/
  FILE_CLOSE,		/* ե򥯥		*/
  FILE_GETATTR,		/* ե°			*/
  FILE_SETATTR,		/* ե°			*/
  FILE_READ,		/* եɤ߼   	   	*/
  FILE_WRITE,		/* եν񤭹      		*/
  FILE_TRANC,		/* եΥѹ		*/
  FILE_MKDIR,		/* ǥ쥯ȥ       		*/
  FILE_RMDIR,		/* ǥ쥯ȥ       		*/
  FILE_MKNOD,		/* ڥեκ 		*/
  FILE_RMNOD,           /* ڥեκ 		*/
  FILE_LINK,            /* եΥϡɥ   		*/
  FILE_REMOVE,		/* եκ			*/
  FILE_SELECT,		/* ǥХ select       		*/
  FILE_CONTROL,		/* ե           		*/
  FILE_MOVE,		/* եΰư(̾ѹ)  		*/

  FILE_MOUNTROOT,	/* root ե륷ƥΥޥ	*/
  FILE_MOUNT,		/* ե륷ƥΥޥ		*/
  FILE_UNMOUNT,		/* ե륷ƥΥޥ	*/
};

typedef enum file_request file_request_t;


/*
 * ե ID
 */
struct fileid
{
  unsigned short	hostid;		/* ۥ ID */
  unsigned short	fsid;		/* ե륷ƥ ID */
  unsigned long		fileno;		/* եֹ */
};


/*
 * եޥ͡㤬֤顼ֹ
 */
enum file_error
{
  FILE_EOK,		/* ｪλ 				*/
  FILE_ENOMEM,		/* ƥΰΥ()­ʤ	*/
  FILE_EUNKNOWN,	/* åǤʤ             */
  FILE_ENOSPT,		/* ̤ݡ */
};

typedef enum file_error	file_error_t;


/*
 * ǡ׵ѥåȤѥåȤ롣
 */
struct file_access_req
{
  char	path[PATH_MAX];
  int	mode;
};

typedef struct file_access_req	file_access_req_t;

/*
 * եǤդΥѡߥåꤹ뤿׵ѥå
 *
 */
struct file_setattr_req
{
  char	path[PATH_MAX];
  int	mode;
};

typedef struct file_setattr_req	file_setattr_req_t;


/*
 * ե륵Ф׵ѥå
 *
 */
struct fm_msg
{
  SVC_REQ	header;

  union
    {
      struct file_access_req	file_access_req;
      struct file_setattr_req	file_setattr_req;
    } body;
};

typedef struct fm_msg	fm_msg_t;


/*
 * ե륵Ф֤äƤѥå
 */
struct file_reply
{
  SVC_REQ	header;

  file_error_t		error;

  /*
   * ׵ᤴȤ˰ۤʤΰ
   */
};

typedef struct file_reply	file_reply_t;


#endif /* __SERVER_FILE_H__ */
