/* The cheapest, quickest to write program I can make up to strip line numbers.
// The line number field is variable width and has optional leading whitespace.
// Written by Joel Rees, Takino, Hyogo, Japan, January 2000.
// Too Q&D to bother copyrighting, assigned to the public domain.
// Since it is in the public domain, it can't be copyrighted. 
// Your personal expression of it may be copyrightable, however.
//
// The changes in my programing style prove that I am turning Japanese.
// Current e-mail: joel_rees@sannet.ne.jp, reiisi@nettaxi.com
*/


/* #define ON_Macintosh */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>


#if defined ON_Macintosh
#	pragma		push
#	pragma		only_std_keywords off
#	include		<Types.h>
#	include		<Fonts.h>
#	pragma		pop
#endif


#if defined ON_Macintosh
#	include		<sioux.h>
#	include		<console.h>
#endif


#define BUFFERCHARS	1024
#define BUFFSIZE	( BUFFERCHARS + 1 )	/* One shot, should be no lines this large anyway. */
#define LABELCHARS 16	/* I think it was only up to 8, but 16 to be safe. */
#define LABELSIZE ( LABELCHARS + 1 )	/* I think it was only up to 8, but 16 to be safe. */
#define NAMECHARS 31
#define NAMESIZE ( NAMECHARS + 1 )
#define EXPRESSIONCHARS 64	/* Way overkill. */
#define EXPRESSIONSIZE ( EXPRESSIONCHARS + 1 )


#define SPACE ' '


char * derelative( char buffer[] )
{	char * scan = buffer;
	int ch;
	while ( ( ( ch = * scan ) != '\0' )
			&& ( ch != '-' ) && ( ch != '+' ) )
	{	++scan;
	}
	if ( scan > buffer )
	{	*scan = '\0';
		return buffer;
	}
}


char * prefixHeaderAddress( char buffer[] )
{	return isdigit( buffer[ 0 ] ) ? "" : "(natural_t) &h";
}


int nocaseCompare( char * range, char * object )
{	int difference = 0;
	/* printf( "comparing %s in %s:", object, range ); */
	do
	{	difference = ( toupper( * range++ ) - toupper( * object++ ) );
		/* printf( "%d,", difference ); */
	} while ( ( difference == 0 ) && ( * object != '\0' ) );	/* terminating NUL is convenient in the math. */
	/* printf( "%d\n", difference ); */
	return difference;
}


char * nocaseScan( char * range, char * object )
{	char * inObject = object;
	while ( ( * range != '\0' ) && ( nocaseCompare( range, object ) != 0 ) )	/* Not going for speed. */
	{	++range;
	}
	return ( * range == '\0' ) ? NULL : range;
}


char * guardedCopy( char target[], char source[], size_t limit )
{	target[ limit ] = '\0';
	strncpy( target, source, limit );
}


#if defined NOT_USING_THIS
/* Decided I want to try to matche fgets(). */
size_t readline( FILE * file, char buffer[], size_t limit )
{	size_t i;
	int ch;
	int lookahead;
	for ( i = 0; i < limit; ++i )
	{	ch = fgetc( file );
		if ( ch == EOF )
		{	buffer[ i ] = '\0';
			--i;	/* Report the count of stored characters. */
			break;
		}
		else if ( ( ch == '\n') || ( ch == '\r' ) )
		{	if ( i == limit - 1 )
			{	ungetc( ch, file );
				buffer[ i ] = '\0';
				--i;	/* Report the count of stored characters. */
			}
			else 
			{	buffer[ i ] = '\n';	/* convert to standard C library new line */
				buffer[ i + 1 ] = '\0';
				lookahead = fgetc( file );
				if ( ( ( ch == '\n' ) && ( lookahead != '\r' ) )
					 || ( ( ch == '\r' ) && ( lookahead != '\n' ) ) )
				{	ungetc( lookahead );	/* Don't drop it. */
				}
				/* If it was a CRLF or LFCR, drop the second of the pair. */
			}
			break;
		}
		else
		{	buffer[ i ] = (char) ch;
		}
	}
	return i;
}
#endif /* defined NOT_USING_THIS */
size_t readline( FILE * file, char buffer[], size_t limit )
{	size_t i;
	int ch;
	int lookahead;
	--limit;	/* store limit - 1 characters */
	for ( i = 0; i < limit; ++i )
	{	ch = fgetc( file );
		if ( ch == EOF )
		{	break;
		}
		else if ( ( ch == '\n') || ( ch == '\r' ) )
		{
			buffer[ i++ ] = '\n';	/* convert to standard C library new line for the platform */
			lookahead = fgetc( file );
			if ( ( ( ch == '\n' ) && ( lookahead != '\r' ) )
				 || ( ( ch == '\r' ) && ( lookahead != '\n' ) ) )
			{	ungetc( lookahead, file );	/* Not a pair, don't drop it. */
			}
			/* If it was a CRLF or LFCR, drop the second of the pair. */
			break;
		}
		else
		{	buffer[ i ] = (char) ch;
		}
	}
	buffer[ i ] = '\0';
	return i;
}


int main( int argc, char * argv[] )
{
	int ch;
	FILE * input = stdin;
	int fdbFlag = 0;
	int dotHFlag = 0;
	char label[ LABELSIZE ] = { '\0' };
	char name[ NAMESIZE ] = { '\0' };
	char searchMode[ EXPRESSIONSIZE ] = { '\0' };
	char linkMode[ EXPRESSIONSIZE ] = { '\0' };
	char allocLink[ EXPRESSIONSIZE ] = { '\0' };
	char parentLink[ EXPRESSIONSIZE ] = { '\0' };
	char leftLink[ EXPRESSIONSIZE ] = { '\0' };
	char rightLink[ EXPRESSIONSIZE ] = { '\0' };
	char lastLabel[ LABELSIZE ] = { '\0' };
	char characteristic[ LABELSIZE ] = { '\0' };
#define HeaderWait 0
#define HeaderNameRead 1
#define HeaderNamed 2
#define HeaderLinkModeRead 3
#define HeaderLinked 4
#define HeaderParented 5
#define HeaderLefted 6
#define HeaderRighted 7
#define HeaderComplete 8
	int headerState = HeaderWait;
/* */
#	if defined ON_Macintosh
	{	Str31 name = "\pOsaka|";
		short familyID = 0;
	/* */
		GetFNum( name, &familyID );
		SIOUXSettings.fontsize = 12;
		SIOUXSettings.fontid = familyID;
		SIOUXSettings.showstatusline = 1;
		argc = ccommand( &argv );
	}
#	endif
	/* Use the pseudo-command-line as simple file interface
	// argc = ccommand( &argv ); 
	*/
	if ( argc > 1 )
	{	int arg;
		for ( arg = 1; arg < argc; ++arg )
		{	if ( ( argc == 2 ) || ( ( strcmp( argv[ arg ], "-f" ) == 0 ) && ( ++arg < argc ) ) )
			{	input = fopen( argv[ arg ], "rb" );
				if ( input == NULL )
				{	fprintf( stderr, "Failed to open %s\n", argv[ arg ] );
					return EXIT_FAILURE;
				}
			}
			else if ( strcmp( argv[ arg ], "-fdb" ) == 0 )
			{	fdbFlag = 1;
			}
			else if ( strcmp( argv[ arg ], "-.h" ) == 0 )
			{	dotHFlag = 1;
			}
			/* else if ( ( strcmp( argv[ arg ], "-e" ) == 0 ) && ( ++arg < argc ) )
			{
			} 
			*/
			else
			{	fprintf( stderr, "Unknown option #%d: %s\n", arg, argv[ arg ] );
			}
		}
	}
/* */
	while ( !feof( input ) )
	{
		char buffer[ BUFFSIZE ];
		char * scan = buffer;
		size_t lineLength;
		int found = 0;
#define FoundFCC 1
#define FoundFCB 2
#define FoundFDB 3
		char * labelMark = NULL;
		char * operatorMark = NULL;
		char * operandMark = NULL;
		char * commentMark = NULL;
		
		buffer[ 0 ] = '\0';	/* In case EOF comes on a completely empty line. */
		lineLength = readline( input, buffer, BUFFSIZE );
		if ( buffer[ lineLength - 1 ] == '\n' )	/* Assuming all lines shorter than the buffer. */
		{	buffer[ lineLength - 1 ] = '\0';
		}
		/* printf( "length of buffer: %d\n\n", strlen( buffer ) ); */
		while ( isspace( * scan ) )
		{	++scan; 
		}
		while ( isdigit( * scan ) )	/* Bump past the line number. */
		{	++scan;
		}
		if ( * scan == SPACE )
		{	++scan;	/* Move past the delimiting space. */
		}
		if ( !fdbFlag && !dotHFlag )
		{	fputs( scan, stdout );
			fputc( '\n', stdout );
			continue;	/* Nothing more to do in strip line number mode. */
		}
		if ( * scan == '\0' )
		{	continue;	/* empty line */
		}
		else if ( * scan == '*' )
		{	continue;	/* comment line */
		}
		if ( ( * scan != '\0' ) && !isspace( * scan ) )	/* Don't want to lose track of whether we tested NUL. */
		{	labelMark = scan++;	/* Saves us a symbol table. I'm pretty sure I didn't put any labels beyond this point. */
			while ( !isspace( * scan ) )
			{	++scan;
			}
			* scan++ = '\0';	/* Make the label its own string. */
		}
		while ( isspace( * scan ) )
		{	++scan;
		}
		if ( * scan != '\0' )
		{	operatorMark = scan;
			while ( ( * scan != '\0' ) && !isspace( * scan ) )
			{	++scan;
			}
			if ( * scan != '\0' )
			{	*scan++ = '\0';
				while ( isspace ( * scan ) )
				{	++scan;
				}
			}
		}
		if ( ( operatorMark != NULL ) && ( nocaseCompare( operatorMark, "FCC" ) == 0 ) )
		{	char quotechar = * scan;
			found = FoundFCC;
			if ( quotechar != '\0' )
			{	++scan;
				operandMark = scan;
			}
			while ( ( * scan != '\0' ) && ( * scan != quotechar ) )
			{	++scan;
			}
			if ( * scan != '\0' )
			{	* scan++ = '\0';
				while ( isspace ( * scan ) )
				{	++scan;
				}
			}
			if ( * scan != '\0' )
			{	commentMark = scan;
			}
			if ( ( operandMark != NULL ) && ( headerState == HeaderWait ) )
			{	guardedCopy( name, operandMark, NAMECHARS );
				headerState = HeaderNameRead;
			}
		}
		else if ( ( operatorMark != NULL ) && ( nocaseCompare( operatorMark, "FCB" ) == 0 ) )
		{	found = FoundFCB;
			operandMark = scan;
			while ( ( * scan != '\0' ) && !isspace( * scan ) )
			{	++scan;
			}
			if ( * scan != '\0' )
			{	* scan++ = '\0';
				while ( isspace ( * scan ) )
				{	++scan;
				}
			}
			if ( * scan != '\0' )
			{	commentMark = scan;
			}
			switch ( headerState )
			{
			case HeaderNameRead:
				guardedCopy( searchMode, operandMark, EXPRESSIONCHARS );
				headerState = HeaderNamed;
				break;
			case HeaderNamed:
				guardedCopy( linkMode, operandMark, EXPRESSIONCHARS );
				headerState = HeaderLinkModeRead;
				break;
			}
		}
		else if ( ( operatorMark != NULL ) && ( nocaseCompare( operatorMark, "FDB" ) == 0 ) )
		{	found = FoundFDB;
			operandMark = scan;
			while ( ( * scan != '\0' ) && !isspace( * scan ) )
			{	++scan;
			}
			if ( * scan != '\0' )
			{	* scan++ = '\0';
				while ( isspace ( * scan ) )
				{	++scan;
				}
			}
			if ( * scan != '\0' )
			{	commentMark = scan;
			}
			switch ( headerState )
			{
			case HeaderLinkModeRead:
				guardedCopy( allocLink, operandMark, EXPRESSIONCHARS );
				headerState = HeaderLinked;
				break;
			case HeaderLinked:
				guardedCopy( parentLink, operandMark, EXPRESSIONCHARS );
				headerState = HeaderParented;
				break;
			case HeaderParented:
				guardedCopy( leftLink, operandMark, EXPRESSIONCHARS );
				headerState = HeaderLefted;
				break;
			case HeaderLefted:
				guardedCopy( rightLink, operandMark, EXPRESSIONCHARS );
				headerState = HeaderRighted;
				break;
			}
		}
		else
		{	if ( ( headerState == HeaderRighted ) && ( labelMark != NULL ) && ( operatorMark != NULL ) )
			{	guardedCopy( label, labelMark, LABELCHARS );
				if ( ( toupper( operatorMark[ 0 ] ) == 'D' ) && ( ( toupper( operatorMark[ 1 ] ) == 'O' ) ) )
				{	guardedCopy( characteristic, operatorMark + 1, LABELCHARS );
					characteristic[ 0 ] = 'X';
				}
				else
				{	guardedCopy( characteristic, labelMark, LABELCHARS );
				}
				headerState = HeaderComplete;
			}
		}
		if ( headerState == HeaderComplete )
		{	if ( dotHFlag )
			{	printf( "extern definition_header_s h%s;\n", label );
				if ( strcmp( label, characteristic ) == 0 )
				{	printf( "extern void %s(void);\n", label );
				}
			}
			if ( fdbFlag )
			{
				fputs( "*/\n", stdout );
				printf( "static character_t s%s[] = \"\\x%x\" \"%s\";\n", label, strlen( name ), name );
				printf( "definition_header_s h%s = \n", label );
				printf( "{\t{ (natural_t) s%s },\n", label );
				printf( "\t{ %s },\n", searchMode );
				derelative( allocLink );
				printf( "\t{ %s%s },\n", prefixHeaderAddress( allocLink ), allocLink );	/* Need to see comments? */
				printf( "\t{ %s },\n", linkMode );
				derelative( parentLink );
				printf( "\t{ %s%s },\n", prefixHeaderAddress( parentLink ), parentLink );
				derelative( leftLink );
				printf( "\t{ %s%s },\n", prefixHeaderAddress( leftLink ), leftLink );
				derelative( rightLink );
				printf( "\t{ %s%s },\n", prefixHeaderAddress( rightLink ), rightLink );
				printf( "\t{ (natural_t) %s }%s\n", 
					characteristic, 
					( strcmp( label, characteristic ) == 0 ) ? "\n};" : "," 
				);
				fputs( "/*\n", stdout );
			}
			headerState = HeaderWait;
		}
		else if ( fdbFlag && ( found == FoundFDB ) 
				  && ( ( headerState == HeaderComplete ) || ( headerState == HeaderWait ) ) )
		{	if ( labelMark != NULL )
			{	printf( "/* %s: */\n", labelMark );
			}
			fputs( "\t\t{ (natural_t) &h", stdout );
			if ( operandMark != NULL )
			{	fputs( operandMark, stdout ); 
			}
			fputs( "\t},", stdout );
			if ( commentMark != NULL )
			{	fputs( "\t/* ", stdout );
				fputs( commentMark, stdout );
				fputs( " */", stdout );
			}
			fputc( '\n', stdout );
		}
	}
	return EXIT_SUCCESS;
}

