/*
**  bif_ioex.c
**  bif-c
**
**  Created by Joel Rees on 2014/03/20.
**  Copyright 2014 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFB/A, as mechanically as possible.
*/


// #include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>


#include "bif_eval.h"
#include "bif_m.h"
#include "bifst_a.h"	/* for break_pressed() */
#include "bif_ex.h"


static character_t sEXTENSIONS[] = "\x0a" "EXTENSIONS";
definition_header_s hEXTENSIONS =
{	{ (natural_t) sEXTENSIONS },
	{ MIMM },
	{ (natural_t) &LASTinIO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XVOC }, 
	{	{ (natural_t) &hEMIT_LEDS }	}
};


static int led_fd = -1;

static character_t sOPEN_LEDS[] = "\x8" "OPEN_LEDS";
definition_header_s hOPEN_LEDS =	
{	{ (natural_t) sOPEN_LEDS },
	{ 0 },
	{ (natural_t) &hEXTENSIONS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) OPEN_LEDS }
};
/*
OPEN_LEDS    ( --- )
//      Open the unit LEDs device for R/W. 
//
//      This is not the way to do this, but we will do it for now.
*/
void OPEN_LEDS(void)	/* Temporary code to just get output, for now. */
{
	led_fd = open( "/dev/dio104_led", O_RDWR );
	if ( led_fd == -1 )
	{	perror( "Opening LEDS failed!" );
	}
}

static character_t sCLOSE_LEDS[] = "\x9" "CLOSE_LEDS";
definition_header_s hCLOSE_LEDS =	
{	{ (natural_t) sCLOSE_LEDS },
	{ 0 },
	{ (natural_t) &hOPEN_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) CLOSE_LEDS }
};
/*
CLOSE_LEDS    ( --- )
//      CLose the unit LEDs device. 
//
//      This is not the way to do this, but we will do it for now.
*/
void CLOSE_LEDS(void)	/* Temporary code to just get output, for now. */
{
	if ( close( led_fd ) == -1 )
	{	perror( "Closing LEDS failed!!" );
	}
}


static character_t sEMIT_LEDS[] = "\x8" "EMIT_LEDS";
definition_header_s hEMIT_LEDS =	
{	{ (natural_t) sEMIT_LEDS },
	{ 0 },
	{ (natural_t) &hCLOSE_LEDS },
	{ MFORE },
	{ (natural_t) &hEXTENSIONS },
	{ 0 },
	{ 0 },
	{ (natural_t) EMIT_LEDS }
};
/*
EMIT_LEDS    ( c --- )
//      Write c to the unit LEDs. 
//
//      This is not the way to do this, but we will do it for now.
*/
void EMIT_LEDS(void)	/* Temporary code to just get output, for now. */
{
	char ch = (byte_t) ( * SP++ ).integer;
	if ( write( led_fd, &ch, 1 ) != 1 )
	{	perror( "Problem writing to LEDSs!!" );
	}
}

