/* A quick program to extend a file to a block boundary size.
// Copyright Joel Rees, Amagasaki, Hyougo, Japan February 2014.
// May be used under any GPL license 
// or under conditions equivalent to the MIT template open source license
// or BSD two clause license.
*/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>


#define DEFAULT_BLOCKSIZE	256

#define NO_EXIT_ON_SHOW	0	/* for exitflag */
#define EXIT_ON_SHOW	( !0 )	/* for exitflag */
void showusage( char * execpath, int exitflag )
{
/*
	printf( "usage: %s [-b <sz> ] [ -e|c <ct> ] [ <infile> ... ] [ -o <outfile> ]\n", argv[ 0 ] ); 
*/
	printf( "usage: %s [-f <fch>] [-b <sz>] [-e|c <ct>]\n", 
		execpath );
	puts( "\t-n (no filtering)" );
	puts( "\t-p (partial blocks not extended)" );
	puts( "\t-f <filler-character> (default: SPACE)" );
	printf( "\t-b <block-size> (default: %d)\n", DEFAULT_BLOCKSIZE );
	puts( "\t-e <extend-block-count>" );
	puts( "\t-c <result-block-count>" );
	puts( "\t\t(default: filter unprintables to filler character)\n" );
	puts( "\t\t(default: extend to next block boundary)\n" );
	puts( "\tInput from stdin, output to stdout.\n" );
/*
	puts( "\t- (input from stdin)\n" );
//	puts( "\tMultiple input files will be concatenated.\n" );
*/
	if ( exitflag )
	{	exit( EXIT_SUCCESS );
	}
}

int blockSize = DEFAULT_BLOCKSIZE;
int blockCount = 0;
int extendCount = 1;	/* one too many */

void setIntParameter( int * paramp, int * argxp, int argc, char * argv[], char * name, int exitflag )
{	char * endp = NULL;
	long parameter = * paramp;
	if ( ++( * argxp ) < argc )
	{	parameter = strtol( argv[ * argxp ], &endp, 0 );
	}
	if ( ( endp == NULL ) || ( endp == argv[ * argxp ] ) )
	{	printf( "Bad %s: %s, %s.\n", 
			name, argv[ * argxp ], exitflag ? "stopping" : "continuing" );
		printf( "%s -h for usage help.", argv[ 0 ] );
		if ( exitflag )
		{	exit( EXIT_FAILURE );
		}
	}
	* paramp = (int) parameter;
}

FILE * input = NULL;
FILE * output = NULL;
char filler = ' ';
int filtering = 1;
int partial = 0;

void setParameters( int argc, char * argv[] )
{
	int argx;

	input = stdin;
	output = stdout;

	for ( argx = 1; argx < argc; ++argx )
	{	char * arg = argv[ argx ];
		if ( * arg == '-' )
		{	if ( * ++arg == '-' )
			{	++arg;
			}
			switch ( tolower( * arg ) )
			{
			case 'n':
				filtering = 0;
				break;
			case 'p':
				partial = 1;
				break;
			case 'f':
				if ( ++argx < argc )
				{	filler = argv[ argx ][ 0 ];
				}
				else
				{	printf( "No filler provided, using <%c>(0x%02x)\n", 
						filler, filler );
				}
				break;
			case 'b':
				setIntParameter( &blockSize, &argx, argc, argv, "block size", EXIT_ON_SHOW );
				extendCount = 0;
				break;
			case 'c':
				setIntParameter( &blockCount, &argx, argc, argv, "block count", EXIT_ON_SHOW );
				break;
			case 'e':
				setIntParameter( &extendCount, &argx, argc, argv, "extend count", EXIT_ON_SHOW );
				++extendCount;
				break;
			case 'h':
			default:
				showusage( argv[ 0 ], EXIT_ON_SHOW );
				break;
			}
		}
	}
	if ( blockCount > 0 )
	{	extendCount = 0;
	}
}


int main( int argc, char * argv[] )
{	int ch = '\0';
	int blockswritten;
	int chcount;

	setParameters( argc, argv );
	if ( extendCount > 0 )
	{	blockCount = 1;
	}
	for ( blockswritten = 0; 
		!feof( input ) && ( blockswritten < blockCount );
		++blockswritten )
	{	for ( chcount = 0; !feof( input ) && ( chcount < blockSize ); ++chcount )
		{	if ( ( ch = fgetc( input ) ) == EOF )
			{	break;
			}
			if ( filtering && !isprint( ch ) )
			{	ch = filler;
			}
			fputc( ch, output );
		}
		if ( ch == EOF )
		{	break;
		}
		if ( extendCount > 0 )
		{	++blockCount;
		}
	}
/*
fprintf( stderr, "written: %d, extending: %d, partial: %d\n",
blockswritten, extendCount, chcount );
*/
	if ( !partial )
	{	if ( extendCount > 0 )
		{	--blockCount;	/* Restore the block count even. */
			--extendCount;	/* Make it a true count. */
		}
		/* fill out partial block first time through. */
		for ( /* 空　*/; blockswritten < blockCount; chcount = 0, ++blockswritten )
		{
			for ( /* 空 */; chcount < blockSize; ++chcount )
			{	fputc( filler, output );
			}
			if ( --extendCount > 0 )
			{	++blockCount;
			}
		}
	}
	return EXIT_SUCCESS;
}

