/*
**  bif_ioex.h
**  bif-c
**
**  Created by Joel Rees on 2014/03/20.
**  Copyright 2014 __Reiisi_Kenkyuu__. All rights reserved.
**
**  IO stuff for the SH-3 target at Hyougo Polytec.
*/


#if !defined BIF_IOEX_H
#define BIF_IOEX_H


#include "bifu_i.h"


extern definition_header_s hEXTENSIONS;

extern definition_header_s hOPEN_LEDS;
extern void OPEN_LEDS(void);

extern definition_header_s hCLOSE_LEDS;
extern void CLOSE_LEDS(void);

extern definition_header_s hEMIT_LEDS;
extern void EMIT_LEDS(void);

extern definition_header_s hREAD_LEDS;
extern void READ_LEDS(void);

extern definition_header_s hOPEN_SWS;
extern void OPEN_SWS(void);

extern definition_header_s hOPEN_SWSNBF;
extern void OPEN_SWSNBF(void);

extern definition_header_s hCLOSE_SWS;
extern void CLOSE_SWS(void);

extern definition_header_s hREAD_SWS;
extern void READ_SWS(void);

extern definition_header_s hOPEN_7SEGS;
extern void OPEN_7SEGS(void);

extern definition_header_s hCLOSE_7SEGS;
extern void CLOSE_7SEGS(void);

extern definition_header_s hEMIT_7SEGS;
extern void EMIT_7SEGS(void);

extern definition_header_s hREAD_7SEGS;
extern void READ_7SEGS(void);

extern definition_header_s hOPEN_LCD;
extern void OPEN_LCD(void);

extern definition_header_s hCLOSE_LCD;
extern void CLOSE_LCD(void);

extern definition_header_s hEMIT_LCD;
extern void EMIT_LCD(void);

extern definition_header_s hTYPE_LCD;
extern void TYPE_LCD(void);

extern definition_header_s hCLR_LCD;
extern void CLR_LCD(void);

#if defined READY_FOR_READING_LCD
extern definition_header_s hREAD_LCD;
extern void READ_LCD(void);
#endif /* defined READY_FOR_READING_LCD */


#define LASTinIOEX	hCLR_LCD


#endif /* !defined BIF_IOEX_H */
