#pragma once
#include "resource.h"


class CFileEditDlg: public CDialogImpl<CFileEditDlg>,
					public CWinDataExchange<CFileEditDlg>
{
public:
	enum { IDD = IDD_FILE_EDIT };

	BEGIN_DDX_MAP(CFileEditDlg)
		DDX_CONTROL_HANDLE(IDC_EDIT_LOCAL_FILE_NAME,		m_editLocalFileName)
		DDX_TEXT          (IDC_EDIT_LOCAL_FILE_NAME,		m_strLocalFileName)
		DDX_CONTROL_HANDLE(IDC_EDIT_REMOTE_FILE_NAME,		m_editRemoteFileName)
		DDX_TEXT          (IDC_EDIT_REMOTE_FILE_NAME,		m_strRemoteFileName)
		DDX_CONTROL_HANDLE(IDC_EDIT_OFFSET,					m_editOffset)
		DDX_CONTROL_HANDLE(IDC_EDIT_SIZE,					m_editSize)
		DDX_CONTROL_HANDLE(IDC_CHECK_EOF,					m_checkEOF)
		DDX_CONTROL_HANDLE(IDC_LIST_FILE_RANGE,				m_listFileRange)
		DDX_CONTROL_HANDLE(IDC_BUTTON_ADD_RANGE,			m_buttonAddRange)
		DDX_CONTROL_HANDLE(IDC_BUTTON_REMOVE_RANGE,			m_buttonRemoveRange)
		DDX_CONTROL_HANDLE(IDOK,							m_buttonOK)
		DDX_CONTROL_HANDLE(IDCANCEL,						m_buttonCancel)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CFileEditDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,					OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,				OnCancel)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_ADD_RANGE,	OnAddRangeButtonDown)
		COMMAND_HANDLER_EX(IDC_EDIT_LOCAL_FILE_NAME,	EN_CHANGE,	OnEnChangeFileName)
		COMMAND_HANDLER_EX(IDC_EDIT_REMOTE_FILE_NAME,	EN_CHANGE,	OnEnChangeFileName)
		COMMAND_HANDLER_EX(IDC_EDIT_OFFSET,				EN_CHANGE,	OnEnChangeRangeInfo)
		COMMAND_HANDLER_EX(IDC_EDIT_SIZE,				EN_CHANGE,	OnEnChangeRangeInfo)
		COMMAND_HANDLER_EX(IDC_CHECK_EOF,				BN_CLICKED,	OnEnChangeRangeInfo)
		NOTIFY_HANDLER_EX(IDC_LIST_FILE_RANGE,			LVN_ITEMCHANGED,	OnFileRangeListItemChanged)
	END_MSG_MAP()

	static const DWORD FILE_OFFSET_COLUMN_INDEX		= 0;
	static const DWORD FILE_OFFSET_COLUMN_WIDTH		= 155;
	static const DWORD FILE_SIZE_COLUMN_INDEX		= 1;
	static const DWORD FILE_SIZE_COLUMN_WIDTH		= 155;

	CFileEditDlg(__in BG_JOB_TYPE jobType, bool bBITS20Supported);

	__checkReturn inline CString GetLocalFileName() const {
		return m_strLocalFileName; 
	}
	__checkReturn inline CString GetRemoteFileName() const {
		return m_strRemoteFileName; 
	}

	CAtlArray<BG_FILE_RANGE> m_FileRangeArray;

private:
	CEdit		m_editLocalFileName;
	CString		m_strLocalFileName;
	CEdit		m_editRemoteFileName;
	CString		m_strRemoteFileName;
	CEdit		m_editOffset;
	CEdit		m_editSize;
	CButton		m_checkEOF;
	CListViewCtrl	m_listFileRange;
	CButton		m_buttonAddRange;
	CButton		m_buttonRemoveRange;
	CButton		m_buttonOK;
	CButton		m_buttonCancel;

	BG_JOB_TYPE	m_jobType;
	bool m_bBITS20Supported;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnAddRangeButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeFileName(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeRangeInfo(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnFileRangeListItemChanged(LPNMHDR /*pnmh*/);

	bool InitDialogControls(void);
	bool InitFileRangeList(void); 

	bool SetDialogTitle(void);

	bool UpdateUI(void);
	bool UpdateRemoveRangeButton(void);
	bool UpdateRangeUI(void);

	bool SetFileRangeInfoToListItem(int nItemIndex, BG_FILE_RANGE* pFileRange);

	bool DeleteListItem(int nItemIndex);
	bool DeleteAllListItems(void);

	bool SaveFileRangeList(void);
};
