#include "StdAfx.h"
#include "JobAdvancedSetting1Page.h"
#include "JobChangeReplyFilePathDlg.h"
#include "JobEditNotifyCommandDlg.h"
#include "WTLCtrlUtil.h"
#include "BITSDef.h"
#include "BITSUtil.h"
#include "MiscUtil.h"


CJobAdvancedSetting1Page::CJobAdvancedSetting1Page(void)
{
	NULL;
}


CJobAdvancedSetting1Page::~CJobAdvancedSetting1Page(void)
{
	NULL;
}


LRESULT CJobAdvancedSetting1Page::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLASSERT(m_spJob2);
	ATLASSERT(m_spBITSManager);

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(RefreshUI());
	ATLVERIFY(SetTimer(REFRESH_TIMER_ID, REFRESH_INTERVAL));

	return TRUE;
}


LRESULT CJobAdvancedSetting1Page::OnDestroy(void)
{
	ATLVERIFY(KillTimer(REFRESH_TIMER_ID));

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnTimer(__in UINT_PTR nIDEvent)
{
	switch (nIDEvent) {
		case REFRESH_TIMER_ID:
			if (FALSE != IsWindowVisible()) {
				ATLVERIFY(RefreshUI());
			}
			break;

		default:
			break;
	}

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnChangeNotifyCommandButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CString strNotifyCommandPath	= GetNotifyCommandPathFromControl();
	CString strNotifyCommandArg		= GetNotifyCommandArgFromControl();

	CJobEditNotifyCommandDlg dlg;
	dlg.SetNotifyCommandPath(strNotifyCommandPath);
	dlg.SetNotifyCommandArg(strNotifyCommandArg);
	INT_PTR nAnswer = dlg.DoModal();
	if (IDOK != nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::SetJobNotifyCmdLine(m_spJob2, dlg.GetNotifyCommandPath(), dlg.GetNotifyCommandArg());
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_NOTIFY_COMMAND_CHANGE_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnChangeReplyFileNameButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CJobChangeReplyFilePathDlg dlg;
	CString strReplyFileName = GetReplyFileNameFromControl();
	dlg.SetReplyFilePath(strReplyFileName);
	INT_PTR nAnswer = dlg.DoModal(m_hWnd);
	if (IDOK != nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::SetJobReplyFileName(m_spJob2, dlg.GetReplyFilePath());
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_REPLY_FILE_CHANGE_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}
	
	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnSetCredentialsButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	BG_AUTH_TARGET authTarget = GetAuthTargetFromRadioButton();
	BG_AUTH_SCHEME authScheme = GetAuthSchemeFromComboBox();

	CString strQuestion;
	strQuestion.Format(IDS_QUESTION_SET_CREDENTIALS, GetAuthTargetString(authTarget), GetAuthSchemeString(authScheme));
	int nAnswer = MiscUtil::ShowMessageBox(m_hWnd, strQuestion, NULL, MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}
	ATLVERIFY(IDYES == nAnswer);

	WCHAR szUserName[BITS_MAX_AUTH_USER_NAME_LEN + 1]	= {0};
	WCHAR szPassword[BITS_MAX_AUTH_PASSWORD_LEN + 1]	= {0};
	m_editAuthUserName.GetWindowText(szUserName, _countof(szUserName));
	m_editAuthPassword.GetWindowText(szPassword, _countof(szPassword));

	BG_AUTH_CREDENTIALS credentials;
	::ZeroMemory(&credentials, sizeof(credentials));
	credentials.Target	= authTarget;
	credentials.Scheme	= authScheme;
	credentials.Credentials.Basic.UserName = szUserName;
	credentials.Credentials.Basic.Password = szPassword;

	HRESULT hr = BITSUtil::SetJobCredentials(m_spJob2, &credentials);

#pragma warning(disable: 6385)	// ȂR[hxôŗ}
	::SecureZeroMemory(szUserName, sizeof(szUserName));
	::SecureZeroMemory(szPassword, sizeof(szPassword));
#pragma warning(default: 6385)

	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_SET_CREDENTIALS_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	ATLASSERT(SUCCEEDED(hr));
	MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_JOB_CREDENTIALS_SET, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

	ATLVERIFY(ClearAuthInfoEdit());
	ATLVERIFY(UncheckAuthSchemeRadioButton());
	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnRemoveCredentialsButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	BG_AUTH_TARGET authTarget = GetAuthTargetFromRadioButton();
	BG_AUTH_SCHEME authScheme = GetAuthSchemeFromComboBox();

	CString strQuestion;
	strQuestion.Format(IDS_QUESTION_REMOVE_CREDENTIALS,  GetAuthTargetString(authTarget), GetAuthSchemeString(authScheme));
	int nAnswer = MiscUtil::ShowMessageBox(m_hWnd, strQuestion, NULL, MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}
	ATLVERIFY(IDYES == nAnswer);

	HRESULT hr = BITSUtil::RemoveJobCredentials(m_spJob2, authTarget, authScheme);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));
		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_REMOVE_CREDENTIALS_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);
	} else if (S_FALSE == hr) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NO_JOB_CREDENTIALS_REMOVED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
	} else {
		ATLASSERT(SUCCEEDED(hr));
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_JOB_CREDENTIALS_REMOVED, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);
	}

	ATLVERIFY(ClearAuthInfoEdit());
	ATLVERIFY(UncheckAuthSchemeRadioButton());
	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnAuthRadioButtonChecked(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateAuthRelatedControls());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnSelChangeAuthScheme(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateAuthRelatedControls());

	return 0;
}


LRESULT CJobAdvancedSetting1Page::OnEnChangeEditAuth(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	ATLVERIFY(UpdateAuthRelatedControls());

	return 0;
}


bool CJobAdvancedSetting1Page::InitPropertyPageControls(void)
{
	if (false == InitAuthSchemeComboBox()) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(InitAuthEditControls());

	return true;
}


bool CJobAdvancedSetting1Page::InitAuthSchemeComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboAuthScheme, IDS_JOB_AUTH_BASIC,
		static_cast<DWORD_PTR>(BG_AUTH_SCHEME_BASIC));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboAuthScheme, IDS_JOB_AUTH_DIGEST,
		static_cast<DWORD_PTR>(BG_AUTH_SCHEME_DIGEST));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboAuthScheme, IDS_JOB_AUTH_NTLM,
		static_cast<DWORD_PTR>(BG_AUTH_SCHEME_NTLM));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboAuthScheme, IDS_JOB_AUTH_SNEGO,
		static_cast<DWORD_PTR>(BG_AUTH_SCHEME_NEGOTIATE));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboAuthScheme, IDS_JOB_AUTH_PASSPORT,
		static_cast<DWORD_PTR>(BG_AUTH_SCHEME_PASSPORT));
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(SetAuthSchemeToComboBox(BG_AUTH_SCHEME_BASIC));

	return true;
}


bool CJobAdvancedSetting1Page::InitAuthEditControls(void)
{
	m_editAuthUserName.SetLimitText(BITS_MAX_AUTH_USER_NAME_LEN);
	m_editAuthPassword.SetLimitText(BITS_MAX_AUTH_PASSWORD_LEN);

	return true;
}


bool CJobAdvancedSetting1Page::RefreshUI(void)
{
	ATLVERIFY(RefreshReplyFileInfo());
	ATLVERIFY(RefreshNotifyCommandInfo());
	ATLVERIFY(UpdateAuthRelatedControls());

	return true;
}


bool CJobAdvancedSetting1Page::RefreshNotifyCommandInfo(void)
{
	CString strNotifyCommandPath;
	CString strNotifyCommandArg;

	HRESULT hr = BITSUtil::GetJobNotifyCmdLine(m_spJob2, &strNotifyCommandPath, &strNotifyCommandArg);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editNotifyCommandPath, strNotifyCommandPath));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editNotifyCommandArg, strNotifyCommandArg));

	return true;
}


bool CJobAdvancedSetting1Page::RefreshReplyFileInfo(void)
{
	BG_JOB_TYPE jobType = BG_JOB_TYPE_DOWNLOAD;
	CComPtr<IBackgroundCopyJob> spJob = m_spJob2;
	HRESULT hr = BITSUtil::GetJobType(spJob, &jobType);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (BG_JOB_TYPE_UPLOAD_REPLY != jobType) {
		m_buttonChangeReplyFileName.EnableWindow(FALSE);
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editReplyFileName, IDS_NOT_APPLICABLE));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticReplyFileSize, IDS_NOT_APPLICABLE));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred, IDS_NOT_APPLICABLE));

		return true;
	}

	m_buttonChangeReplyFileName.EnableWindow(TRUE);

	CString strReplyFileName;
	hr = BITSUtil::GetJobReplyFileName(m_spJob2, &strReplyFileName);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (true == strReplyFileName.IsEmpty()) {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editReplyFileName, L""));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticReplyFileSize, IDS_NOT_APPLICABLE));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred, IDS_NOT_APPLICABLE));

		return true;
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editReplyFileName, strReplyFileName));

	BG_JOB_REPLY_PROGRESS progress = {0};
	hr = BITSUtil::GetJobReplyProgress(m_spJob2, &progress);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	CString strReplyFileSize;
	if (BG_SIZE_UNKNOWN == progress.BytesTotal) {
		strReplyFileSize = L"0";
	} else {
		strReplyFileSize = MiscUtil::FormatNumber(progress.BytesTotal);
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticReplyFileSize, strReplyFileSize));

	CString strByteTransferred;
	if (BG_SIZE_UNKNOWN == progress.BytesTransferred) {
		strByteTransferred = L"0";
	} else {
		strByteTransferred = MiscUtil::FormatNumber(progress.BytesTransferred);
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred, strByteTransferred));

	return true;
}


bool CJobAdvancedSetting1Page::UpdateAuthRelatedControls(void)
{
	if (BST_CHECKED != m_radioServerAuth.GetCheck() && BST_CHECKED != m_radioProxyAuth.GetCheck()) {
		m_comboAuthScheme.EnableWindow(FALSE);
		m_editAuthUserName.EnableWindow(FALSE);
		m_editAuthPassword.EnableWindow(FALSE);
		m_buttonSetCredentials.EnableWindow(FALSE);
		m_buttonRemoveCredentials.EnableWindow(FALSE);

		return true;
	}

	m_comboAuthScheme.EnableWindow(TRUE);
	m_editAuthUserName.EnableWindow(TRUE);
	m_editAuthPassword.EnableWindow(TRUE);
	m_buttonRemoveCredentials.EnableWindow(TRUE);

	CString strUserName;
	m_editAuthUserName.GetWindowText(strUserName);
	if (false == strUserName.IsEmpty()) {
		m_buttonSetCredentials.EnableWindow(TRUE);
	} else {
		m_buttonSetCredentials.EnableWindow(FALSE);
	}

	return true;
}


bool CJobAdvancedSetting1Page::UncheckAuthSchemeRadioButton(void)
{
	m_radioProxyAuth.SetCheck(BST_UNCHECKED);
	m_radioServerAuth.SetCheck(BST_UNCHECKED);

	ATLVERIFY(UpdateAuthRelatedControls());

	return true;
}


bool CJobAdvancedSetting1Page::ClearAuthInfoEdit(void)
{
	m_editAuthUserName.SetWindowText(L"");
	m_editAuthPassword.SetWindowText(L"");

	return true;
}


__checkReturn BG_AUTH_TARGET CJobAdvancedSetting1Page::GetAuthTargetFromRadioButton(void)
{
	if (BST_CHECKED == m_radioProxyAuth.GetCheck()) {
		ATLASSERT(BST_CHECKED != m_radioServerAuth.GetCheck());
		return BG_AUTH_TARGET_PROXY;
	}

	ATLASSERT(BST_CHECKED == m_radioServerAuth.GetCheck());
	return BG_AUTH_TARGET_SERVER;
}


bool CJobAdvancedSetting1Page::SetAuthTargetToRadioButton(__in BG_AUTH_TARGET authTarget)
{
	ATLASSERT(BITSUtil::VerifyAuthTarget(authTarget));

	if (BG_AUTH_TARGET_PROXY == authTarget) {
		m_radioProxyAuth.SetCheck(BST_CHECKED);
		m_radioServerAuth.SetCheck(BST_UNCHECKED);
	} else {
		m_radioProxyAuth.SetCheck(BST_UNCHECKED);
		m_radioServerAuth.SetCheck(BST_CHECKED);
	}

	return true;
}


__checkReturn BG_AUTH_SCHEME CJobAdvancedSetting1Page::GetAuthSchemeFromComboBox(void)
{
	int nCurSel = m_comboAuthScheme.GetCurSel();
	ATLASSERT(CB_ERR != nCurSel);

	return static_cast<BG_AUTH_SCHEME>(m_comboAuthScheme.GetItemData(nCurSel));
}


bool CJobAdvancedSetting1Page::SetAuthSchemeToComboBox(__in BG_AUTH_SCHEME authScheme)
{
	ATLASSERT(BITSUtil::VerifyAuthScheme(authScheme));

	int nItemCount = m_comboAuthScheme.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (authScheme == static_cast<BG_AUTH_SCHEME>(m_comboAuthScheme.GetItemData(nIndex))) {
			m_comboAuthScheme.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


CString CJobAdvancedSetting1Page::GetAuthTargetString(__in BG_AUTH_TARGET authTarget)
{
	ATLASSERT(BITSUtil::VerifyAuthTarget(authTarget));

	CString strTarget;
	BOOL bResult = FALSE;
	if (BG_AUTH_TARGET_SERVER == authTarget) {
		bResult = strTarget.LoadString(IDS_JOB_AUTH_TARGET_SERVER);
	} else {
		ATLASSERT(BG_AUTH_TARGET_PROXY == authTarget);
		bResult = strTarget.LoadString(IDS_JOB_AUTH_TARGET_PROXY);
	}
	if (FALSE == bResult) {
		ATLASSERT(false);
		return L"";
	}

	return strTarget;
}


CString CJobAdvancedSetting1Page::GetAuthSchemeString(__in BG_AUTH_SCHEME authScheme)
{
	ATLASSERT(BITSUtil::VerifyAuthScheme(authScheme));

	CString strScheme;
	BOOL bResult = strScheme.LoadString(IDS_JOB_AUTH_BASIC + authScheme - 1);
	if (FALSE == bResult) {
		ATLASSERT(false);
		return L"";
	}

	return strScheme;
}


CString CJobAdvancedSetting1Page::GetReplyFileNameFromControl(void)
{
	CString strReplyFileName;
	m_editReplyFileName.GetWindowText(strReplyFileName);

	return strReplyFileName;
}


CString CJobAdvancedSetting1Page::GetNotifyCommandPathFromControl(void)
{
	CString strNotifyCommandPath;
	m_editNotifyCommandPath.GetWindowText(strNotifyCommandPath);

	return strNotifyCommandPath;
}


CString CJobAdvancedSetting1Page::GetNotifyCommandArgFromControl(void)
{
	CString strNotifyCommandArg;
	m_editNotifyCommandArg.GetWindowText(strNotifyCommandArg);

	return strNotifyCommandArg;
}


__checkReturn bool CJobAdvancedSetting1Page::IsBITS15Supported(void)
{
	if (!m_spJob2) {
		return false;
	}

	return true;
}


void CJobAdvancedSetting1Page::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob2) {
		ATLASSERT(false);
		m_spJob2.Release();
	}

	m_spJob2 = spJob;

	return;
}


void CJobAdvancedSetting1Page::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}

