#pragma once


class CBITSItem
{
public:
	CBITSItem(void);
	~CBITSItem(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	__checkReturn CComPtr<IBackgroundCopyManager> GetBITSManagerIF(void) const;

	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);
	__checkReturn CComPtr<IBackgroundCopyJob> GetJobIF(void) const;

	inline __checkReturn GUID GetJobId(void) const
	{
		return m_jobId; 
	}

	inline void SetJobId(__in GUID jobId)
	{
		m_jobId = jobId;
	}

private:
	CComPtr<IBackgroundCopyJob>		m_spJob;
	CComPtr<IBackgroundCopyManager> m_spBITSManager;
	GUID							m_jobId;

	CBITSItem(const CBITSItem&);
	CBITSItem& operator=(const CBITSItem&);
};
