#include "stdafx.h"
#include "resource.h"
#include "aboutdlg.h"
#include "MainFrm.h"


CAppModule _Module;

int Run(LPTSTR lpstrCmdLine = NULL, int nCmdShow = SW_SHOWDEFAULT);

int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE /* hPrevInstance */, LPTSTR lpstrCmdLine, int nCmdShow)
{
	_CrtSetDbgFlag(_CRTDBG_LEAK_CHECK_DF | _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG));

	HRESULT hr = ::CoInitializeEx(NULL, COINIT_MULTITHREADED);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return -1;
	}

	hr = ::CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_CONNECT, RPC_C_IMP_LEVEL_IMPERSONATE,
		NULL, EOAC_DYNAMIC_CLOAKING, NULL);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return -1;
	}

	AtlInitCommonControls(ICC_WIN95_CLASSES);

	hr = _Module.Init(NULL, hInstance);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return -1;
	}

	int nRet = Run(lpstrCmdLine, nCmdShow);

	_Module.Term();

	::CoUninitialize();

	return nRet;
}


int Run(LPTSTR /*lpstrCmdLine = NULL */, int nCmdShow /* =SW_SHOWDEFAULT */)
{
	CMessageLoop theLoop;
	_Module.AddMessageLoop(&theLoop);

	CMainFrame wndMain;
	if (wndMain.CreateEx() == NULL) {
		ATLASSERT(false);
		return -1;
	}
	wndMain.ShowWindow(nCmdShow);

	int nRet = theLoop.Run();

	_Module.RemoveMessageLoop();
	return nRet;
}