#include "StdAfx.h"
#include "IconUtil.h"


__checkReturn
HBITMAP IconUtil::FromIconToBitmap(__in HICON hIcon)
{
	if (NULL == hIcon) {
		ATLASSERT(false);
		return NULL;
	}

	ICONINFO iconInfo = {0};
	if (!::GetIconInfo(hIcon, &iconInfo)) {
		ATLASSERT(false);
		return NULL;
	}

	BITMAPINFOHEADER bitmapInfoHeader	= {0};
	bitmapInfoHeader.biSize      = sizeof(BITMAPINFOHEADER);
	bitmapInfoHeader.biWidth     = iconInfo.xHotspot * 2;
	bitmapInfoHeader.biHeight    = iconInfo.yHotspot * 2;
	bitmapInfoHeader.biPlanes    = 1;
	bitmapInfoHeader.biBitCount  = 32;

	BITMAPINFO bitmapInfo	= {0};
	bitmapInfo.bmiHeader	= bitmapInfoHeader;

	LPVOID lpBits = NULL;
	HBITMAP hBitmap = ::CreateDIBSection(NULL, reinterpret_cast<LPBITMAPINFO>(&bitmapInfo), DIB_RGB_COLORS, &lpBits, NULL, 0);
	if (NULL == hBitmap) {
		ATLASSERT(false);
		return NULL;
	}

	HDC hdcMem = ::CreateCompatibleDC(NULL);
	if (NULL == hdcMem) {
		ATLASSERT(false);
		return NULL;
	}

	HBITMAP hPrevBitmap = reinterpret_cast<HBITMAP>(::SelectObject(hdcMem, hBitmap));
	if (0 == ::DrawIconEx(hdcMem, 0, 0, hIcon, bitmapInfoHeader.biWidth, bitmapInfoHeader.biHeight, 0, NULL, DI_NORMAL)) {
		ATLASSERT(false);
		return NULL;
	}
	::SelectObject(hdcMem, hPrevBitmap);
	ATLVERIFY(::DeleteDC(hdcMem));

	return hBitmap;
}
