#include "StdAfx.h"
#include "OSVersionUtil.h"


bool OSVersionUtil::IsVistaOrLater(void)
{
	OSVERSIONINFOEX versionInfo = {0};
	versionInfo.dwOSVersionInfoSize = sizeof(versionInfo);
	versionInfo.dwMajorVersion = 6;

	DWORDLONG dwlConditionMask = 0;
	VER_SET_CONDITION(dwlConditionMask, VER_MAJORVERSION, VER_GREATER_EQUAL);

	if (!::VerifyVersionInfo(&versionInfo, VER_MAJORVERSION, dwlConditionMask)) {
		ATLASSERT(ERROR_OLD_WIN_VERSION == ::GetLastError());
		return false;
	}

	return true;
}
