#include "StdAfx.h"
#include "JobNoProgressTimeoutSettingDlg.h"
#include "MiscUtil.h"
#include "BITSUtil.h"


CJobNoProgressTimeoutSettingDlg::CJobNoProgressTimeoutSettingDlg(void)
{
	NULL;
}


CJobNoProgressTimeoutSettingDlg::~CJobNoProgressTimeoutSettingDlg(void)
{
	NULL;
}


LRESULT CJobNoProgressTimeoutSettingDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLASSERT(m_spJob);

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());
	ATLVERIFY(CenterWindow(GetParent()));

	return TRUE;
}


LRESULT CJobNoProgressTimeoutSettingDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	BOOL bSuccess = FALSE;
	UINT ulNoProgressTimeout = GetDlgItemInt(IDC_EDIT_NO_PROGRESS_TIMEOUT, &bSuccess, FALSE);
	if (FALSE == bSuccess) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_NO_PROGRESS_TIMEOUT_VALUE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	HRESULT hr = BITSUtil::SetJobNoProgressTimeout(m_spJob, ulNoProgressTimeout);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	EndDialog(nID);

	return 0;
}


LRESULT CJobNoProgressTimeoutSettingDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	EndDialog(nID);

	return 0;
}


LRESULT CJobNoProgressTimeoutSettingDlg::OnEnChangeNoProgressTimeout(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CString strNoProgressTimeout;
	m_editNoProgressTimeout.GetWindowText(strNoProgressTimeout);

	if (true == strNoProgressTimeout.IsEmpty()) {
		m_buttonOK.EnableWindow(FALSE);
	} else {
		m_buttonOK.EnableWindow(TRUE);
	}

	return 0;
}


bool CJobNoProgressTimeoutSettingDlg::InitDialogControls(void)
{
	ULONG ulNoProgressTimeout = 0;
	HRESULT hr = BITSUtil::GetJobNoProgressTimeout(m_spJob, &ulNoProgressTimeout);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	CString strNoProgressTimeout;
	strNoProgressTimeout.Format(L"%u", ulNoProgressTimeout);
	m_editNoProgressTimeout.SetWindowText(strNoProgressTimeout);

	ATLVERIFY(MiscUtil::SetUINTMaxTextLimit(&m_editNoProgressTimeout));

	return true;
}


void CJobNoProgressTimeoutSettingDlg::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobNoProgressTimeoutSettingDlg::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);

	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob = spJob;

	return;
}
