#pragma once
#include "resource.h"


class CJobNoProgressTimeoutSettingDlg: public CDialogImpl<CJobNoProgressTimeoutSettingDlg>,
	public CWinDataExchange<CJobNoProgressTimeoutSettingDlg>
{
public:
	enum { IDD = IDD_NO_PROGRESS_TIMEOUT_SETTING };

	BEGIN_DDX_MAP(CJobRetryDelaySettingDlg)
		DDX_CONTROL_HANDLE(IDOK,							m_buttonOK)
		DDX_CONTROL_HANDLE(IDC_EDIT_NO_PROGRESS_TIMEOUT,	m_editNoProgressTimeout)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobRetryDelaySettingDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,		OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,	OnCancel)
		COMMAND_HANDLER_EX(IDC_EDIT_NO_PROGRESS_TIMEOUT, EN_CHANGE,	OnEnChangeNoProgressTimeout)
	END_MSG_MAP()

	CJobNoProgressTimeoutSettingDlg(void);
	~CJobNoProgressTimeoutSettingDlg(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);


private:
	CButton m_buttonOK;
	CEdit	m_editNoProgressTimeout;

	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeNoProgressTimeout(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitDialogControls(void);
};
