using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

namespace Boon
{
    /// <summary>
    /// ׂẴNX狤ʂėp郁\bhi[NXłB
    /// ׂẴ\bhstaticŐ錾Ă܂B
    /// </summary>
    static class BoonCommon
    {
        /// <summary>
        /// Oo͂t@CłB
        /// </summary>
        static String logFilename = "log.txt";

        /// <summary>
        /// Ŏw肳ꂽOo͂܂B
        /// </summary>
        /// <param name="logData">Oo͂镶</param>
        public static void writeLog(String logData)
        {
            using (StreamWriter sw = new StreamWriter(BoonCommon.logFilename, true))
            {
                sw.WriteLine(BoonCommon.getDateString() );
                sw.WriteLine("--------------------------------------------------------------------------------");
                sw.WriteLine(logData);
                sw.WriteLine("--------------------------------------------------------------------------------");
                sw.WriteLine();
            }
        }

        /// <summary>
        /// ݂̓𕶎ƂĎ擾܂B
        /// </summary>
        /// <returns>݂̓</returns>
        private static string getDateString()
        {
            return (DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"));
        }

        /// <summary>
        /// Ŏw肳ꂽbɑΉ錻ݓ𕶎ƂĎ擾܂B
        /// </summary>
        /// <param name="timeSeconds"></param>
        /// <returns>݂̓</returns>
        public static string getDateString(long timeSeconds)
        {
            return (DateTime.FromFileTime(timeSeconds).ToString("yyyy/MM/dd HH:mm:ss"));
		}
		/// <summary>
		/// _E[hNp̃N𐶐܂B
		/// </summary>
		/// <param name="url">_E[hN쐬錳URL</param>
		/// <param name="title">_E[hN쐬錳̃^Cg</param>
		/// <returns>_E[hNpN</returns>
		private static string getBoonLinkString(string url, string title)
		{
			Regex regex = new Regex(@"^(http://www.nicovideo.jp/)?watch/([a-zA-Z0-9]+)$");
			Match match = regex.Match(url);

			if(match.Success)
			{
				return ("http://boon?url=" + System.Web.HttpUtility.UrlEncode(url)
					+ "&title=" + System.Web.HttpUtility.UrlEncode(title)
					+ "&videoID=" + System.Web.HttpUtility.UrlEncode(match.Groups[2].ToString()));
			}
			return ("");
		}

		public const string Url_NicoRoot = "http://www.nicovideo.jp/";
		public const string Url_NicoMyPage = "http://www.nicovideo.jp/";
		public const string Url_NicoSearch = "http://www.nicovideo.jp/search/";

		public static Regex Regex_UrlIsNicoDomain = new Regex("^(?<protocol>http[s]?)://(?<locale>www|de|tw|es)\\.nicovideo\\.jp/(?<relativepath>[\\S]*)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
		public static Regex Regex_UrlIsNicoWatchPage = new Regex("^http://(?<locale>www|de|tw|es)\\.nicovideo\\.jp/watch/(?<movieid>[a-zA-Z]{0,2}?[\\d]{1,12})", RegexOptions.Compiled | RegexOptions.IgnoreCase);
		public static Regex Regex_StringIsMovieID = new Regex("^[a-zA-Z]{0,2}(?<number>[\\d]{1,12})$",RegexOptions.Compiled | RegexOptions.IgnoreCase);
		//public static Regex Regex_NicoTitleCheck = new Regex("(?<title>\\S+?)]jRjR\\(\\)$", RegexOptions.None);

		/// <summary>
		/// <see cref="System.String"/>AASCIIR[hŏI[Ƀk(\0)\<value>byte</value>zɕϊ܂B
		/// Null̏ꍇ͒0bytez񂪁A0̏ꍇ̓k݂̂1bytez񂪕Ԃ܂B
		/// </summary>
		/// <param name="str">ϊ<see cref="System.String"/></param>
		/// <returns>ASCII\bytez</returns>
		public static byte[] StringToASCIIBytes(string str)
		{
			if(str == null) { return new byte[0]; }

			byte[] strbyte = Encoding.Unicode.GetBytes(str);
			byte[] asciibyte = Encoding.Convert(Encoding.Unicode, Encoding.ASCII, strbyte);
			strbyte = new byte[asciibyte.Length + 1];
			for(int i = 0; i < asciibyte.Length; ++i) strbyte[i] = asciibyte[i];
			strbyte[asciibyte.Length] = 0;
			return strbyte;
		}
    }
}
