using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.Serialization;

using ProjectBoon.Win32;

using Marshal = System.Runtime.InteropServices.Marshal;
using IServiceProvider = ProjectBoon.Win32.IServiceProvider;

namespace Boon.Controls.Browsers
{

	#region Security Managemant

	/// <summary>
	/// InternetSecurityManagerɂċANV\܂
	/// rbgtB[h^̃tOł
	/// </summary>
	[Serializable]
	[Flags]
	public enum SecurityFlags : uint
	{
		/// <summary>
		/// Script,JAVA,ActiveX̃ANV͖ɂȂ܂
		/// </summary>
		None = 0x00000000,
		/// <summary>
		/// Script̎s܂
		/// </summary>
		Script = 0x00000FFF,
		/// <summary>
		/// JAVA̎s܂
		/// </summary>
		JAVA = 0x0000F000,
		/// <summary>
		/// ActiveXvOC̎s܂
		/// </summary>
		AxExecute = 0x00FF0000,
		/// <summary>
		/// ActiveXvOC̃_E[h܂
		/// </summary>
		AxDownload = 0x0F000000,
	}

	/// <summary>
	/// WebBrowserExŗpZLeB}l[W[łB
	/// IInternetSecurityManager̃wp[NXłB
	/// </summary>
	public class InternetSecurityManager
		: IInternetSecurityManager,
		IServiceProviderForIISM
	{
		#region Const

		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ftHgiǂ̃][ɂĂȂƁj\B
		/// </summary>
		public const int SEC_INDEX_DEF = 0;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ݒ肪LłȂA[U[ɂݒɌŒ肵Ă邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_MY = 1;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ZoneAɑĂ邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_A = 2;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ZoneBɑĂ邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_B = 3;

		public const string NO_MATCH_PATTERN = @"[^\s\S]";

		#endregion

		#region Field

		private SecurityFlags[] _security;
		private bool _autoSecurity = true;

		private int _current_zone_key = SEC_INDEX_DEF;
		private Regex _urlZone_matchA;
		private Regex _urlZone_matchB;

		#endregion


		/// <summary>
		/// URLɂčœKȃ][𔻒fă][ݒ肵܂B
		/// WebBrowsery[WJڂۂɌĂяoĂB
		/// </summary>
		/// <param name="url">][̔fƂȂURL</param>
		public void NavigateToPage(string url)
		{
			// Original Zone
			if(!this.AutoSecurity)
			{
				this._current_zone_key = SEC_INDEX_MY;
			}
			else if(this._urlZone_matchA != null && this._urlZone_matchA.IsMatch(url))
			{
				this._current_zone_key = SEC_INDEX_A;
			}
			else if(this._urlZone_matchB != null && this._urlZone_matchB.IsMatch(url))
			{
				this._current_zone_key = SEC_INDEX_B;
			}
			else
			{
				this._current_zone_key = SEC_INDEX_DEF;
			}
		}

		#region Properties

		/// <summary>
		/// ݗpĂ][擾܂B
		/// ĺÃNXconsto[łSEC_INDEX_`ɑΉĂ܂B
		/// </summary>
		public int CurrentZone
		{
			get { return this._current_zone_key; }
		}

		/// <summary>
		/// URL𗘗pĎŃ][𔻒fĐݒ肷邩ǂ擾Eݒ肵܂B
		/// ̒lfalse̎ANavigateToPagesĂZLeB̏ԂύX܂B
		/// </summary>
		/// <remarks>
		/// ̒lfalsȅꍇACurrentZonevpeB<see cref="SEC_INDEX_DEF"/>Ԃ܂B
		/// ̒lύXĂACurrentZone͒ɕύX킯ł͂܂B
		/// <see cref="NavigateToPage"/>Ăяoꂽɔf܂B
		/// </remarks>
		public bool AutoSecurity
		{
			get { return this._autoSecurity; }
			set { this._autoSecurity = value; }
		}
		/// <summary>
		/// <see cref="CurrentZone"/><see cref="SEC_INDEX_MY"/>̏ꍇɗp<see cref="SecurityFlags"/>̐ݒ擾Eݒ肵܂B
		/// AutoSecurityfalse̎ɓKpݒł邱ƂӖ܂B
		/// </summary>
		public SecurityFlags MySecurityFlags
		{
			get { return this._security[SEC_INDEX_MY]; }
			set { this._security[SEC_INDEX_MY] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAׂẴ][`ɓKȂꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// </summary>
		public SecurityFlags DefaultSecurityFlags
		{
			get { return this._security[SEC_INDEX_DEF]; }
			set { this._security[SEC_INDEX_DEF] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAZoneȀɓKꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// ZoneAZoneBD揇ʂɂ܂B
		/// </summary>
		public SecurityFlags SecurityFlagsZoneA
		{
			get { return this._security[SEC_INDEX_A]; }
			set { this._security[SEC_INDEX_A] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAZoneB̏ɓKꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// ZoneAZoneBD揇ʂɂ܂B
		/// </summary>
		public SecurityFlags SecurityFragsZoneB
		{
			get { return this._security[SEC_INDEX_B]; }
			set { this._security[SEC_INDEX_B] = value; }
		}

		/// <summary>
		/// ZoneA̒`擾Eݒ肵܂BURL񂪁ÃvpeBl̐K\Ƀ}b`邩ǂfłB
		/// Al<see cref="System.String.Empty"/>̏ꍇASׂ̈ɂURLZoneAɃ}b`ȂȂ܂B
		/// </summary>
		public string UrlZoneA
		{
			get { return this._urlZone_matchA == null ? String.Empty : this._urlZone_matchA.ToString(); }
			set { this._urlZone_matchA = value == String.Empty ? null : new Regex(value); }
		}
		/// <summary>
		/// ZoneB̒`擾Eݒ肵܂BURL񂪁ÃvpeBl̐K\Ƀ}b`邩ǂfłB
		/// Al<see cref="System.String.Empty"/>̏ꍇASׂ̈ɂURLZoneBɃ}b`ȂȂ܂B
		/// </summary>
		public string UrlZoneB
		{
			get { return this._urlZone_matchB == null ? String.Empty : this._urlZone_matchB.ToString(); }
			set { this._urlZone_matchB = value == String.Empty ? null : new Regex(value); }
		}

		#endregion

		/// <summary>
		/// ̃NX̃RXgN^łBCX^X쐬Anꂽ<see cref="System.Windows.Forms.WebBrowser"/>ActiveXInstanceɃA^b`܂B
		/// </summary>
		/// <param name="browserCore">̃IuWFNg𗘗pWebBrowserIServiceProviderActiveXRA</param>
		public InternetSecurityManager(object browserCore)
		{
			this._security = new SecurityFlags[] { SecurityFlags.None, SecurityFlags.None, SecurityFlags.None, SecurityFlags.None };
			this._urlZone_matchA = null;
			this._urlZone_matchB = null;
			this._autoSecurity = true;

			IServiceProvider pISP = browserCore as IServiceProvider;
			if(pISP == null) { throw new ArgumentException("InternetSecurityManager::ctorɓnꂽsłB\ñIuWFNgIServiceProvider𗘗pł܂B"); }
			object obj = null;
			pISP.QueryService(ref ComDefines.SID_SProfferService, ref ComDefines.IID_IProfferService, out obj);
			IProfferService IProf = obj as IProfferService;
			int cookie = 0;
			IProf.ProfferService(ref ComDefines.IID_IInternetSecurityManager, this as IServiceProviderForIISM, ref cookie);
		}

		#region IInternetSecurityManager o

		int IInternetSecurityManager.ProcessUrlAction(string pwszUrl, int dwAction, out byte pPolicy, int cbPolicy, byte pContext, int cbContext, int dwFlags, int dwReserved)
		{
			//Trace.WriteLine(String.Format("{0} : {1:x}", pwszUrl, dwAction));
			pPolicy = 0;
			int key = this.CurrentZone;

			// // iGoogle ΍
			// bool isGoogle = false;
			// if(Regex.IsMatch(pwszUrl, @"^http://[^\.\s]+\.google\.co\.[^\.]+", RegexOptions.Singleline))
			// {
			//     isGoogle = true;
			// }

			if(URLACTION.SCRIPT_MIN <= dwAction && dwAction <= URLACTION.SCRIPT_MAX)
			{
				if((this._security[key] & SecurityFlags.Script) == SecurityFlags.Script)
					//&& !isGoogle)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.JAVA_MIN <= dwAction && dwAction <= URLACTION.JAVA_MAX)
			{
				if((this._security[key] & SecurityFlags.JAVA) == SecurityFlags.JAVA)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.ACTIVEX_RUN == dwAction)
			{
				if((this._security[key] & SecurityFlags.AxExecute) == SecurityFlags.AxExecute)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(dwAction == URLACTION.DOWNLOAD_UNSIGNED_ACTIVEX || dwAction == URLACTION.DOWNLOAD_SIGNED_ACTIVEX)
			{
				if((this._security[key] & SecurityFlags.AxDownload) == SecurityFlags.AxDownload)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			if(dwAction == URLACTION.BEHAVIOR_RUN)
			{
				pPolicy = URLPOLYCY.DISALLOW;
				return ComDefines.S_OK;
			}
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.MapUrlToZone(string pwszUrl, out int pdwZone, int dwFlags)
		{
			pdwZone = 0;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetSecurityId(string pwszUrl, byte[] pbSecurityId, ref uint pcbSecurityId, uint dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.SetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.QueryCustomPolicy(string pwszUrl, ref Guid guidKey, byte ppPolicy, int pcbPolicy, byte pContext, int cbContext, int dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.SetZoneMapping(int dwZone, string lpszPattern, int dwFlags)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetZoneMappings(int dwZone, out System.Runtime.InteropServices.ComTypes.IEnumString ppenumString, int dwFlags)
		{
			ppenumString = null;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		#endregion

		#region IServiceProviderForIISM o

		int IServiceProviderForIISM.QueryService(ref Guid guidService, ref Guid riid, out IInternetSecurityManager ppvObject)
		{
			ppvObject = null;
			if(guidService == ComDefines.IID_IInternetSecurityManager)
			{
				ppvObject = this as IInternetSecurityManager;
				return ComDefines.S_OK;
			}
			return ComDefines.E_NOINTERFACE;
		}

		#endregion
	}

	#endregion

	#region Travel Log Management

	/// <summary>
	/// uEŨirQ[V̗Ǘ邽߂̃NXł
	/// </summary>
	public class ExHtmlHistory : IDisposable
	{
		#region Field
		private ITravelLogStg _travelLog;
		private bool _disposedValue = false;
		#endregion

		/// <summary>
		/// gbNWebBrowserRg[w肵ẴNX쐬܂
		/// </summary>
		/// <param name="browser"></param>
		public ExHtmlHistory(WebBrowserAx browser)
		{
			if(browser == null) throw new NullReferenceException();
			IServiceProvider pISP = null;
			object ppvObject = null;
			Guid SID_STravelLogCursor = new Guid("7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8");
			Guid IID_ITravelLogStg =	new Guid("7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8");
			pISP = (IServiceProvider)browser.Application;
			pISP.QueryService(ref SID_STravelLogCursor, ref IID_ITravelLogStg, out ppvObject);
			this._travelLog = (ITravelLogStg)ppvObject;
		}
		~ExHtmlHistory()
		{
			if(this._travelLog != null)
			{
				Marshal.ReleaseComObject(this._travelLog);
			}
		}

		/// <summary>
		/// ̈ꗗ擾܂
		/// </summary>
		/// <param name="flags">擾闚̃^Cv</param>
		/// <param name="maxEntries">擾闚̍ő吔</param>
		/// <returns>TravelLogEntry̔zAsꍇnull</returns>
		public TravelLogEntry[] EnumEntries(TLENUMF flags, int maxEntries)
		{
			try
			{
				List<TravelLogEntry> history = new List<TravelLogEntry>(maxEntries);
				IEnumTravelLogEntry TLEnum = null;
				if(this._travelLog.EnumEntries(flags, ref TLEnum) == ComDefines.S_FALSE) return null;
				int tmp = 0;
				while(maxEntries > history.Count)
				{
					ITravelLogEntry TLEntry = null;
					int res = TLEnum.Next(1, out TLEntry, out tmp);
					if(TLEntry == null) break;
					history.Add(new TravelLogEntry(TLEntry));
					Marshal.ReleaseComObject(TLEntry);
				}
				Marshal.ReleaseComObject(TLEnum);
				return history.ToArray();
			}
			catch(Exception e)
			{
				InnerLogger.LOut("ExHtmlEntry::EnumEntries / " + e.Message, InnerLogger.ErrorLevel.L0_CRITICAL);
				return null;
			}
		}
		/// <summary>
		/// w肵̈ʒuɈړ܂
		/// </summary>
		/// <param name="offset">߂͕̒lAiޕ͐̒l</param>
		public void TravelTo(int offset)
		{
			ITravelLogEntry TLEntry = null;
			this._travelLog.GetRelativeEntry(offset, out TLEntry);
			this._travelLog.TravelTo(TLEntry);
			Marshal.ReleaseComObject(TLEntry);
		}
		/// <summary>
		/// ɕێĂvfA@w肵Ď擾܂B
		/// </summary>
		/// <param name="flags">@</param>
		/// <returns>ɂvf̐</returns>
		public int GetCount(TLENUMF flags)
		{
			int entries = 0;
			_travelLog.GetCount(flags, out entries);
			return entries;
		}

		/// <summary>
		/// ẅʒuɍ쐬܂
		/// </summary>
		/// <param name="url">쐬闚Ɋ֘AtURL</param>
		/// <param name="title">쐬闚Ɋ֘Aty[W^Cg</param>
		/// <param name="travelLogEntry">ƂȂGg[</param>
		/// <param name="prepend">̑Oɍ쐬ꍇtrueAɍ쐬ꍇfalse</param>
		/// <returns>V쐬ꂽGg[ւ̎Q</returns>
		private ITravelLogEntry InsertEntry(string url, string title, ITravelLogEntry travelLogEntry, bool prepend)
		{
			ITravelLogEntry TLEntry = null;
			this._travelLog.CreateEntry(url, title, travelLogEntry, prepend, out TLEntry);
			return TLEntry;
		}
		/// <summary>
		/// ݈ʒuɂ擾܂B
		/// </summary>
		/// <param name="offset">݂̃Gg[ɂint32lB߂͕l</param>
		/// <returns>擾vf</returns>
		private ITravelLogEntry GetRelativeEntry(int offset)
		{
			ITravelLogEntry TLEntry = null;
			this._travelLog.GetRelativeEntry(offset, out TLEntry);
			return TLEntry;
		}
		/// <summary>
		/// Xgw肵vf폜܂B
		/// </summary>
		/// <param name="travelLogEntry">폜vf</param>
		private void RemoveEntry(ITravelLogEntry travelLogEntry)
		{
			this._travelLog.RemoveEntry(travelLogEntry);
		}

		/// <summary>
		/// ̃IuWFNgJ܂
		/// </summary>
		/// <param name="disposing"></param>
		protected virtual void Dispose(bool disposing)
		{
			if(!this._disposedValue && this._travelLog != null)
			{
				Marshal.ReleaseComObject(this._travelLog);
				this._travelLog = null;
			}
			this._disposedValue = true;
		}

		#region IDisposable o

		public void Dispose()
		{
			if(!this._disposedValue && this._travelLog != null)
			{
				Marshal.ReleaseComObject(this._travelLog);
				this._travelLog = null;
			}
			this._disposedValue = true;
		}

		#endregion
	}
	/// <summary>
	/// uEȔ̗ێNXł
	/// </summary>
	[Serializable]
	public class TravelLogEntry
	{
		const int S_OK = 0x0;
		private string title;
		private string url;

		/// <summary>
		/// ̃NX̃RXgN^łB
		/// ̗쐬܂B
		/// </summary>
		public TravelLogEntry()
		{
			this.title = "";
			this.url = "";
		}
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// A}l[Wȃ|C^擾ėvf쐬܂
		/// </summary>
		/// <param name="iTravLog">|C^</param>
		public TravelLogEntry(ITravelLogEntry iTravLog)
		{
			IntPtr titleptr = IntPtr.Zero;
			IntPtr urlptr = IntPtr.Zero;
			if(iTravLog.GetTitle(out titleptr) == S_OK)
			{
				this.title = Marshal.PtrToStringUni(titleptr);
			}
			if(iTravLog.GetURL(out urlptr) == S_OK)
			{
				this.url = Marshal.PtrToStringUni(urlptr);
			}
			Marshal.FreeCoTaskMem(urlptr);
			Marshal.FreeCoTaskMem(titleptr);
		}
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// ^CgURLw肵ėvf쐬܂
		/// </summary>
		/// <param name="_title">y[W̃^Cg</param>
		/// <param name="_url">y[WURL</param>
		public TravelLogEntry(string _title, string _url)
		{
			this.title = _title;
			this.url = _url;
		}

		/// <summary>
		/// ̃y[W^Cg擾Eݒ肵܂
		/// </summary>
		public string Title
		{
			get { return this.title; }
			set { this.title = value; }
		}
		/// <summary>
		/// URL擾Eݒ肵܂
		/// </summary>
		public string Url
		{
			get { return this.url; }
			set { this.url = value; }
		}
		/// <summary>
		/// I[o[ChĂ܂B
		/// 񂩂Au^Cg(URL)v̕擾܂
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return string.Format("{0}({1})", this.title, this.url);
		}
	}


	#endregion

	internal static class InnerLogger
	{
		public static class ErrorLevel
		{
			/// <summary>
			/// vOɂƂĒvIȃG[o
			/// ł<see cref="TabBrowserException"/>X[܂B
			/// </summary>
			public const int L0_CRITICAL = 0;
			/// <summary>
			/// vOł̕so
			/// </summary>
			public const int L1_ERROR = 1;
			/// <summary>
			/// vOł̕sȏo
			/// ł̓bZ[W{bNX\܂B
			/// </summary>
			public const int L2_WARNING = 2;
			/// <summary>
			/// T|[gȂ[U[ɑ΂o
			/// ł̓bZ[W{bNX\܂B
			/// </summary>
			public const int L3_ALART = 3;
			/// <summary>
			/// ȓ̂AfobOɏdvȂ̂o
			/// ł̓fobOo͂ɂȂ܂B
			/// </summary>
			public const int L4_NOTIFY = 4;
			/// <summary>
			/// ȓ̂AfobOł̏dv̒Ⴂ̂o
			/// ł͕\܂B
			/// </summary>
			public const int L5_LOG = 5;
		}
		/// <summary>
		/// ̃\bhgpďo͂ꂽf[^́A
		/// DebugR\[ɏo͂܂B
		/// </summary>
		/// <param name="message"></param>
		public static void Out(string message)
		{
			Debug.WriteLine(message);
		}
		public static void Out(string format, params object[] obj)
		{
			Debug.WriteLine(String.Format(format, obj));
		}
		/// <summary>
		/// ̃\bhgpďo͂ꂽf[^́A
		/// MsgBoxɏo͂܂B
		/// </summary>
		/// <param name="message"></param>
		public static void OutBox(string message)
		{
			MessageBox.Show(message);
		}
		/// <summary>
		/// ̃\bhgpďo͂f[^́AfobOEg[X̂ݏo͂܂B
		/// </summary>
		/// <param name="m"></param>
		/// <param name="level">0-2:MSGBOX/3-4:Trace/5:Debug</param>
		[Conditional("DEBUG")]
		[Conditional("TRACE")]
		public static void LOut(string m, int level)
		{
			switch(level)
			{
				case 0:
					MessageBox.Show(m);
					throw new TabBrowserException("m");
				case 1:
					MessageBox.Show(m);
					break;
				case 2:
					MessageBox.Show(m);
					break;
				case 3:
					Trace.WriteLine(m);
					break;
				case 4:
					Trace.WriteLine(m);
					break;
				case 5:
					//Debug.WriteLine(m);
					break;
				default:
					MessageBox.Show(m);
					break;
			}
		}
	}


	internal static class TeThrowHelper
	{
		const string CLS_NAME = "Boon.Controls.Browsers.TabBrowserControl";

		public static TabBrowserException ExGeneric(string message, string method)
		{
			TabBrowserException tbe = new TabBrowserException(message);
			tbe.Source = CLS_NAME;
			return tbe;
		}
		public static IndexOutOfRangeException ExIndexOutOfRange()
		{
			IndexOutOfRangeException iex = new IndexOutOfRangeException();
			iex.Source = CLS_NAME;
			return iex;
		}
	}

	#region Exceptions
	/// <summary>
	/// <see cref="TabBrowserControl"/>ŔO\NXłB
	/// </summary>
	public class TabBrowserException : Exception, ISerializable
	{
		public const string DEF_MESSAGE = @"^uuEURg[ŃG[܂B";
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TabBrowserException() : base(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		/// <param name="innerException">ʂ`BꂽO</param>
		public TabBrowserException(Exception innerException) : base(DEF_MESSAGE, innerException) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TabBrowserException(string message) : base(message) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		/// <param name="innerExc">ʂ`BꂽO</param>
		public TabBrowserException(string message, Exception innerExc) : base(message, innerExc) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TabBrowserException(SerializationInfo info, StreamingContext context) :base(info,context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}

	/// <summary>
	/// <see cref="TabBrowserControl"/>ŁA^u<see cref="ITbPageControl"/>̈ΈΉj]Ƃoɔ܂B
	/// </summary>
	public class TeContradictionException : TabBrowserException, ISerializable
	{
		public new const string DEF_MESSAGE = @"^uƃy[W̊֌W̖o܂B";
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TeContradictionException() : base(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TeContradictionException(string message) : base(message) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TeContradictionException(SerializationInfo info, StreamingContext context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}
	/// <summary>
	/// nꂽ<see cref="ITbPageControl"/>A<see cref="System.Windows.Forms.Control"/>pĂȂƂɔ܂B
	/// </summary>
	/// <seealso cref="ITbPageControl"/>
	public class TeInvalidPageException : TabBrowserException, ISerializable
	{
		public new const string DEF_MESSAGE = @"nꂽy[WRg[́ASystem.Windows.Forms.Control̔hNXł͂܂B";

		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TeInvalidPageException() : this(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TeInvalidPageException(string message) : base(message) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TeInvalidPageException(SerializationInfo info, StreamingContext context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}


	#endregion
}
