using System;
using System.Collections.Generic;
using System.Text;

namespace Boon.Controls.Browsers
{

	/// <summary>
	/// <see cref="TabBrowserControl"/>ŗpłݒłB
	/// <see cref="SealInstance"/>ĂяoꂽƁÃNXׂ̂ẴvpeB͎擾݂̂T|[g܂B
	/// </summary>
	/// <exception cref="System.MethodAccessException">IsSealedtruełImmutableȃCX^XɃANZXƔ܂</exception>
	/// <seealso cref="TabBrowserControl"/>
	/// <seealso cref="TabBrowserSettingPage"/>
	[Serializable]
	public class TabBrowserSetting
	{
		#region Field

		private bool _sealed = false;

		private int _max_tab_count;
		private int _max_history_trace;
		private int _max_close_tab_history;

		private bool _enable_edit_title;
		private string _edit_title_matchhost;
		private string _edit_title_pattern;
		private string _edit_title_replace;
		private int _edit_title_maxlength;

		private string _browser_path;
		private LockedTabBehaviors _locked_tab_behavior;

		private bool _enable_auto_security;
		private SecurityFlags _default_security;
		private SecurityFlags _default_security_trust;
		private SecurityFlags _default_security_untrust;
		private string _trustzone_url;
		private string _untrustzone_url;


		private bool _focus_centerclickopen;
		private bool _focus_right_focusedclosed;
		private bool _enable_tabwheel;
		private bool _tabwheel_rotate;
		private TbTabClickAction _ontab_m_down;
		private TbTabClickAction _ontab_l_dclick;
		private TbTabClickAction2 _outtab_l_dclick;
		private TbTabClickAction2 _outtab_wheelclick;
		private TbTabClickAction2 _outtab_r_click;

		#endregion

		#region Property
		/// <summary>
		/// ^uJƂ̏oő吔B
		/// </summary>
		public int MaxTabCount
		{
			get { return this._max_tab_count; }
			set
			{
				if(!this._sealed) { this._max_tab_count = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// Ōɕ^uŕ闚̍ő吔擾܂
		/// </summary>
		public int MaxHistoryTrace
		{
			get { return this._max_history_trace; }
			set
			{
				if(!this._sealed) { this._max_history_trace = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// Ōɕ^uێő吔ł
		/// </summary>
		public int MaxCloseTabHistory
		{
			get { return this._max_close_tab_history; }
			set
			{
				if(!this._sealed) { this._max_close_tab_history = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}

		/// <summary>
		/// y[W^Cg\ύXsǂ擾܂
		/// </summary>
		public bool EnableEditTitle
		{
			get { return this._enable_edit_title; }
			set
			{
				if(!this._sealed) { this._enable_edit_title = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// y[W^Cg\ύXszXg̐K\}b`p^[ł
		/// </summary>
		public string EditTitle_MatchHost
		{
			get { return this._edit_title_matchhost; }
			set
			{
				if(!this._sealed) { this._edit_title_matchhost = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// y[W^Cg\ύX̐K\}b`p^[ł
		/// </summary>
		public string EditTitle_MatchPattern
		{
			get { return this._edit_title_pattern; }
			set
			{
				if(!this._sealed) { this._edit_title_pattern = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// y[W^Cg\̒up^[ł
		/// </summary>
		public string EditTitle_ReplacePattern
		{
			get { return this._edit_title_replace; }
			set
			{
				if(!this._sealed) { this._edit_title_replace = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// y[W^Cg\ύX̎̍ŏIIȍő啶
		/// </summary>
		public int EditTitle_MaxLength
		{
			get { return this._edit_title_maxlength; }
			set
			{
				if(!this._sealed) { this._edit_title_maxlength = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}

		/// <summary>
		/// OuEU̎st@C̃tpXł
		/// </summary>
		public string BrowserPath
		{
			get { return this._browser_path; }
			set
			{
				if(!this._sealed) { _browser_path = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// bNꂽ^u̐U镑ł
		/// ݂܂Lł͂܂
		/// </summary>
		public LockedTabBehaviors LockedTabBehavior
		{
			get { return this._locked_tab_behavior; }
			set
			{
				if(!this._sealed) { this._locked_tab_behavior = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}

		/// <summary>
		/// irQ[gɁAURLɂZLeBGAgp邩ǂł
		/// V^uJɎw肳܂
		/// </summary>
		public bool EnableAutoSecurity
		{
			get { return this._enable_auto_security; }
			set
			{
				if(!this._sealed) { this._enable_auto_security = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// V^uJƂ̃ftHg̃ZLeBԂł
		/// </summary>
		public SecurityFlags DefaultSecurity
		{
			get { return this._default_security; }
			set
			{
				if(!this._sealed) { this._default_security = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// TrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł
		/// </summary>
		public SecurityFlags DefaultSecurityTrust
		{
			get { return this._default_security_trust; }
			set
			{
				if(!this._sealed) { this._default_security_trust = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// UntrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł
		/// </summary>
		public SecurityFlags DefaultSecurityUntrust
		{
			get { return this._default_security_untrust; }
			set
			{
				if(!this._sealed) { this._default_security_untrust = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// MURL\K\ł
		/// </summary>
		public string TrustZoneUrl
		{
			get { return this._trustzone_url; }
			set
			{
				if(!this._sealed) { this._trustzone_url = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ZLeBׂURL\K\ł
		/// </summary>
		public string UntrustZoneUrl
		{
			get { return this._untrustzone_url; }
			set
			{
				if(!this._sealed) { this._untrustzone_url = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}

		/// <summary>
		/// zC[NbNŊJ^uɃtH[JX܂
		/// </summary>
		public bool FocusOnCenterClickOpen
		{
			get { return this._focus_centerclickopen; }
			set
			{
				if(!this._sealed) { this._focus_centerclickopen = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// tH[JX̂^uƂɉEփtH[JXڂ܂
		/// </summary>
		public bool FocusRightWhenFocusedClosed
		{
			get { return this._focus_right_focusedclosed; }
			set
			{
				if(!this._sealed) { this._focus_right_focusedclosed = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^ũzC[őI^uɕύX܂
		/// </summary>
		public bool EnableTabWheel
		{
			get { return this._enable_tabwheel; }
			set
			{
				if(!this._sealed) { this._enable_tabwheel = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^ũzC[őI^uύXƂA[[փ[e[V܂
		/// </summary>
		public bool TabWheelRotate
		{
			get { return this._tabwheel_rotate; }
			set
			{
				if(!this._sealed) { this._tabwheel_rotate = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^uzC[NbN̓
		/// </summary>
		public TbTabClickAction TabMouseDownM
		{
			get { return this._ontab_m_down; }
			set { this._ontab_m_down = value; }
		}
		/// <summary>
		/// ^u_uNbN̓
		/// </summary>
		public TbTabClickAction TabDoubleClickL
		{
			get { return this._ontab_l_dclick; }
			set
			{
				if(!this._sealed) { this._ontab_l_dclick = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^ůO_uNbN̓
		/// </summary>
		public TbTabClickAction2 TabEmptyDoubleClickL
		{
			get { return this._outtab_l_dclick; }
			set
			{
				if(!this._sealed) { this._outtab_l_dclick = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^ůOzC[NbN̓
		/// </summary>
		public TbTabClickAction2 TabEmptyWheelClick
		{
			get { return this._outtab_wheelclick; }
			set
			{
				if(!this._sealed) { this._outtab_wheelclick = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}
		/// <summary>
		/// ^ůOENbNƂ̓
		/// </summary>
		public TbTabClickAction2 TabEmptyClickR
		{
			get { return this._outtab_r_click; }
			set
			{
				if(!this._sealed) { this._outtab_r_click = value; }
				else { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); }
			}
		}

		/// <summary>
		/// ̃CX^XɕύX֎~ɂȂĂ邩ǂ擾܂B
		/// ̒l^̂ƂÃCX^X̃vpeBύXƗO܂B
		/// </summary>
		public bool IsSealed
		{
			get { return this._sealed; }
		}

		#endregion

		/// <summary>
		/// ftHg̃RXgN^B
		/// ׂĂ̏񂪃ftHglŁAMutableȏԂ̃CX^X쐬܂B
		/// Immutableɂꍇ<see cref="SealInstance"/>\bhĂяoĂB
		/// </summary>
		public TabBrowserSetting()
		{
			this.load_default();
		}
		/// <summary>
		/// ̃NX̃Rs[pRXgN^łB
		/// SealĂȂԂ̃CX^X쐬܂B
		/// </summary>
		/// <param name="data">Rs[̃f[^</param>
		public TabBrowserSetting(TabBrowserSetting data)
		{
			this._sealed = false;
			this.MaxTabCount = data.MaxTabCount;
			this.MaxHistoryTrace = data.MaxHistoryTrace;
			this.MaxCloseTabHistory = data.MaxCloseTabHistory;
			this.EnableEditTitle = data.EnableEditTitle;
			this.EditTitle_MatchPattern = data.EditTitle_MatchPattern;
			this.EditTitle_ReplacePattern = data.EditTitle_ReplacePattern;
			this.EditTitle_MatchHost = data.EditTitle_MatchHost;
			this.EditTitle_MaxLength = data.EditTitle_MaxLength;
			this.BrowserPath =data.BrowserPath;
			this.LockedTabBehavior = data.LockedTabBehavior;
			this.EnableAutoSecurity = data.EnableAutoSecurity;
			this.DefaultSecurity = data.DefaultSecurity;
			this.DefaultSecurityTrust = data.DefaultSecurityTrust;
			this.DefaultSecurityUntrust = data.DefaultSecurityUntrust;
			this.TrustZoneUrl = data.TrustZoneUrl;
			this.UntrustZoneUrl = data.UntrustZoneUrl;
			this.FocusOnCenterClickOpen = data.FocusOnCenterClickOpen;
			this.FocusRightWhenFocusedClosed = data.FocusRightWhenFocusedClosed;
			this.EnableTabWheel = data.EnableTabWheel;
			this.TabWheelRotate = data.TabWheelRotate;

			this.TabMouseDownM = data.TabMouseDownM;
			this.TabDoubleClickL = data.TabDoubleClickL;
			this.TabEmptyDoubleClickL = data.TabEmptyDoubleClickL;
			this.TabEmptyWheelClick = data.TabEmptyWheelClick;
			this.TabEmptyClickR = data.TabEmptyClickR;
		}

		/// <summary>
		/// ̃CX^X𕕈󂵁Aȍ~ׂ͂ẴvpeBύXȂƂۏႵ܂B
		/// ̃\bhĂяoꂽAvpeBɒlݒ肷ƗO܂B
		/// </summary>
		public void SealInstance()
		{
			this._sealed = true;
		}

		private void load_default()
		{
			this._sealed = false;
			this.MaxTabCount = 10;
			this.MaxHistoryTrace = 5;
			this.MaxCloseTabHistory = 10;
			this.EnableEditTitle = true;
			this.EditTitle_MatchPattern =
				@"(?<title>.+)(]jRjR\(.+\)|]jRjR`\(.+\)|]NICO NICO DOUGA\(\)).*";
			this.EditTitle_ReplacePattern = @"${title}";
			this.EditTitle_MatchHost = "^http://(www|tw|de|es).nicovideo.jp/";
			this.EditTitle_MaxLength = 0;
			this.BrowserPath = @"C:\Program Files\Internet Explorer\iexplore.exe";
			this.LockedTabBehavior = LockedTabBehaviors.BoonCompatible;
			this.EnableAutoSecurity = true;
			this.DefaultSecurity = SecurityFlags.Script;
			this.DefaultSecurityTrust = SecurityFlags.Script | SecurityFlags.AxExecute;
			this.DefaultSecurityUntrust = SecurityFlags.None;
			this.TrustZoneUrl = @"^https?://(([a-zA-Z0-9]+)\.nicovideo\.jp/|www\.nicochart\.jp/)";
			this.UntrustZoneUrl = @"";
			this.FocusOnCenterClickOpen = false;
			this.FocusRightWhenFocusedClosed = true;
			this.EnableTabWheel = true;
			this.TabWheelRotate = false;

			this.TabMouseDownM = TbTabClickAction.CloseTab;
			this.TabDoubleClickL = TbTabClickAction.LockTab;
			this.TabEmptyDoubleClickL = TbTabClickAction2.OpenBlank;
			this.TabEmptyWheelClick = TbTabClickAction2.ShowRecentClosedMenu;
			this.TabEmptyClickR = TbTabClickAction2.ShowPageListMenu;
		}
	}


	/// <summary>
	/// bNꂽ^u̐U𐧌䂷tOirbgtB[hj
	/// </summary>
	[Flags]
	public enum LockedTabBehaviors : byte
	{
		/// <summary>
		/// bNĂȂ^uƕς͂܂B
		/// </summary>
		AsNotLocked = 0x0,
		/// <summary>
		/// [U[ɂ鑀󂯕t܂
		/// </summary>
		IgnoreClose = 0x1,
		/// <summary>
		/// ^uŃy[WJڂAV^uɊJ܂B
		/// </summary>
		NavigateOnNew = 0x2,
		/// <summary>
		/// ߂Eiޑ^uōs킸AV^uɊJ܂B
		/// </summary>
		ForeBackOnNew = 0x4,
		/// <summary>
		/// ēǂݍ݂^uōs킸AV^uɊJ܂B
		/// </summary>
		ReloadOnNew = 0x8,

		/// <summary>
		/// BOON-SUTAZIOƌ݊̐ݒłB
		/// </summary>
		BoonCompatible = 0x7,
	}
	/// <summary>
	/// ̃^uɒڍp铮`
	/// </summary>
	public enum TbTabClickAction : byte
	{
		/// <summary>
		/// ܂
		/// </summary>
		None = 0x0,
		/// <summary>
		/// ^ubN܂
		/// </summary>
		LockTab = 0x1,
		/// <summary>
		/// ^u܂
		/// </summary>
		CloseTab = 0x3,
		/// <summary>
		/// ^uēǂݍ݂܂
		/// </summary>
		Reload = 0x7,
	}
	/// <summary>
	/// ^uŜɊւ铮`
	/// </summary>
	public enum TbTabClickAction2 : byte
	{
		/// <summary>
		/// ܂
		/// </summary>
		None = 0x0,
		/// <summary>
		/// ̃^uJ܂
		/// </summary>
		OpenBlank = 0x11,
		/// <summary>
		/// o^URL̃^uJ܂
		/// </summary>
		OpenMyUrl = 0x13,
		/// <summary>
		/// \̃y[WꗗJ܂
		/// </summary>
		ShowPageListMenu = 0x31,
		/// <summary>
		/// ŋߕ^üꗗJ܂
		/// </summary>
		ShowRecentClosedMenu = 0x33,
	}

}