using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Boon.Controls.Browsers
{
	/// <summary>
	/// TabBrowserSetting̒lύXׂGUIiłB : UserControlp
	/// </summary>
	public partial class TabBrowserSettingPage : UserControl
	{
		
		/// <summary>
		/// ̃NX̃RXgN^B
		/// gpOSetSettingData𗘗pāAf[^i[ĂB
		/// </summary>
		public TabBrowserSettingPage()
		{
			InitializeComponent();
			this.initialize();
		}
		private TabBrowserSetting _setting = null;

		private void initialize()
		{
			string[] items = new string[4];
			items[0] = "Ȃ";
			items[1] = "V^uJ";
			items[2] = "\̃y[Wꗗ";
			items[3] = "ŋߕ^uꗗ";
			this.tab_cmb_doubleclick.Items.AddRange(new string[]
				{"Ȃ","^ubN","^u","^uēǍ"});
			this.tab_cmb_extabrightclick.Items.AddRange((object[])items.Clone());
			this.tab_cmb_extabdoubleclick.Items.AddRange((object[])items.Clone());
			this.tab_cmb_extabwheelclick.Items.AddRange(items);

			this.man_txt_maxclosedgfhistory.Tag = new int[] { 0, 10 } as object;
			this.man_txt_maxclosedtabs.Tag = new int[] { 0, 20 } as object;
			this.dis_txt_titlemaxchars.Tag = new int[] { 0, int.MaxValue } as object;
			this.dis_txt_testtitle.Text = "jRjR(H)U.BOON]PeXg/ @|[^$@]jRjR(H) ]]]jRjR(H)";

			// ̈זB
			this.man_txt_maxclosedgfhistory.Enabled = false;
		}

		/// <summary>
		/// ̃Rg[ɐݒKp܂B
		/// </summary>
		/// <param name="setting">Kp<see cref="TabBrowserSetting"/></param>
		/// <returns>trueB</returns>
		public bool SetSettingData(TabBrowserSetting setting)
		{
			try
			{
				this._setting = setting;
				// Tab
				int k = 0;
				k = this.conv_TbTabAction_index(setting.TabDoubleClickL);
				this.tab_cmb_doubleclick.SelectedIndex = k;
				k = this.conv_TbTabAction2_index(setting.TabEmptyClickR);
				this.tab_cmb_extabrightclick.SelectedIndex = k;
				k = this.conv_TbTabAction2_index(setting.TabEmptyDoubleClickL);
				this.tab_cmb_extabdoubleclick.SelectedIndex = k;
				k = this.conv_TbTabAction2_index(setting.TabEmptyWheelClick);
				this.tab_cmb_extabwheelclick.SelectedIndex = k;
				this.tab_chk_wheelontab.Checked = setting.EnableTabWheel;
				this.tab_chk_focuswheelopened.Checked = setting.FocusOnCenterClickOpen;
				this.tab_chk_rotatewheel.Checked = setting.TabWheelRotate;
				// Disp
				this.dis_chk_edittitle.Checked = setting.EnableEditTitle;
				this.dis_txt_matchhost.Text = setting.EditTitle_MatchHost;
				this.dis_txt_titlematch.Text = setting.EditTitle_MatchPattern;
				this.dis_txt_titlereplace.Text = setting.EditTitle_ReplacePattern;
				this.dis_txt_titlemaxchars.Text = setting.EditTitle_MaxLength.ToString();
				// Sec
				this.sec_txt_trustzone.Text = setting.TrustZoneUrl;
				this.sec_txt_dangerzone.Text = setting.UntrustZoneUrl;
				this.sec_chk_ui_accept_edit.Checked = false;
				SecurityFlags scf = setting.DefaultSecurity;
				this.sec_chk_commonscript.Checked = (scf & SecurityFlags.Script) == SecurityFlags.Script;
				this.sec_chk_commonactivex.Checked = (scf & SecurityFlags.AxExecute) == SecurityFlags.AxExecute;
				scf = setting.DefaultSecurityTrust;
				this.sec_chk_trustscript.Checked = (scf & SecurityFlags.Script) == SecurityFlags.Script;
				this.sec_chk_trustactivex.Checked = (scf & SecurityFlags.AxExecute) == SecurityFlags.AxExecute;
				// man
				this.man_txt_maxclosedtabs.Text = setting.MaxCloseTabHistory.ToString();
				this.man_txt_maxclosedgfhistory.Text = setting.MaxHistoryTrace.ToString();
			}
			catch(Exception e)
			{
				System.Diagnostics.Trace.WriteLine(String.Format("TabBrowserSettingPage::SetSettingData / ݒ̓KpɎs\nMessage = {0}", e.Message));
				return false;
			}
			// enables
			bool frg = this.dis_chk_edittitle.Checked;
			this.dis_txt_matchhost.Enabled = frg;
			this.dis_txt_titlematch.Enabled = frg;
			this.dis_txt_titlereplace.Enabled = frg;
			frg = this.sec_chk_ui_accept_edit.Checked;
			this.sec_txt_trustzone.Enabled = frg;
			this.sec_txt_dangerzone.Enabled = frg;

			this._setting = setting;

			this.tab_chk_wheelontab_CheckedChanged(null, null);
			return true;
		}
		/// <summary>
		/// ̃Rg[ɂč쐬ꂽݒ擾܂B
		/// ̃\bh́AsꍇnullԂƂ܂B
		/// ̃\bh́AȑOɌĂяoꂽSetSettingDataɂĕۑꂽl㏑܂B
		/// </summary>
		/// <param name="canceled">truew肵ꍇAŌSetSettingData̒lԂ܂</param>
		/// <returns>쐬ꂽ<see cref="TabBrowserSetting"/>Bsꍇnull</returns>
		public TabBrowserSetting GetSettingData(bool canceled)
		{
			if(canceled) return this._setting;

			TabBrowserSetting setting = new TabBrowserSetting();
			try
			{
				// tab
				setting.TabDoubleClickL = this.conv_TbTabAction_index(this.tab_cmb_doubleclick.SelectedIndex);
				setting.TabEmptyClickR = this.conv_TbTabAction2_index(this.tab_cmb_extabrightclick.SelectedIndex);
				setting.TabEmptyDoubleClickL = this.conv_TbTabAction2_index(this.tab_cmb_extabdoubleclick.SelectedIndex);
				setting.TabEmptyWheelClick = this.conv_TbTabAction2_index(this.tab_cmb_extabwheelclick.SelectedIndex);
				setting.EnableTabWheel = this.tab_chk_wheelontab.Checked;
				setting.FocusOnCenterClickOpen = this.tab_chk_focuswheelopened.Checked;
				setting.TabWheelRotate = this.tab_chk_rotatewheel.Checked;
				// dis
				setting.EnableEditTitle = this.dis_chk_edittitle.Checked;
				setting.EditTitle_MatchHost = this.dis_txt_matchhost.Text;
				setting.EditTitle_MatchPattern = this.dis_txt_titlematch.Text;
				setting.EditTitle_ReplacePattern = this.dis_txt_titlereplace.Text;
				int tmp;
				if(Int32.TryParse(this.dis_txt_titlemaxchars.Text, out tmp))
					setting.EditTitle_MaxLength = tmp;
				else
					setting.EditTitle_MaxLength = 0;
				// sec
				setting.TrustZoneUrl = this.sec_txt_trustzone.Text;
				setting.UntrustZoneUrl = this.sec_txt_dangerzone.Text;
				SecurityFlags scf = SecurityFlags.None;
				scf |= (this.sec_chk_commonscript.Checked ? SecurityFlags.Script : SecurityFlags.None);
				scf |= (this.sec_chk_commonactivex.Checked ? SecurityFlags.AxExecute : SecurityFlags.None);
				setting.DefaultSecurity = scf;
				scf = SecurityFlags.None;
				scf |= (this.sec_chk_trustscript.Checked ? SecurityFlags.Script : SecurityFlags.None);
				scf |= (this.sec_chk_trustactivex.Checked ? SecurityFlags.AxExecute : SecurityFlags.None);
				setting.DefaultSecurityTrust = scf;
				setting.DefaultSecurityUntrust = SecurityFlags.None; // \
				// man
				if(Int32.TryParse(this.man_txt_maxclosedtabs.Text, out tmp))
					setting.MaxCloseTabHistory = tmp;
				if(Int32.TryParse(this.man_txt_maxclosedgfhistory.Text, out tmp))
					setting.MaxHistoryTrace = tmp;
				setting.BrowserPath = this.man_txt_browserpath.Text;
			}
			catch(Exception e)
			{
				System.Diagnostics.Trace.WriteLine(String.Format("TabBrowserSettingPage::GetSettingData / ݒ̓KpɎs\nMessage = {0}", e.Message));
				return null;
			}
			setting.SealInstance();
			return setting;
		}


		#region Inner / enum - int Convert

		private int conv_TbTabAction_index(TbTabClickAction act)
		{
			int k = 0;
			switch(act)
			{
				case TbTabClickAction.LockTab:
					k = 1; break;
				case TbTabClickAction.CloseTab:
					k = 2; break;
				case TbTabClickAction.Reload:
					k = 3; break;
				default:
					k = 0; break;
			}
			return k;
		}
		private TbTabClickAction conv_TbTabAction_index(int index)
		{
			TbTabClickAction act = TbTabClickAction.None;
			switch(index)
			{
				case 1:
					act = TbTabClickAction.LockTab;
					break;
				case 2:
					act = TbTabClickAction.CloseTab;
					break;
				case 3:
					act = TbTabClickAction.Reload;
					break;
				default:
					act = TbTabClickAction.None;
					break;
			}
			return act;
		}
		private int conv_TbTabAction2_index(TbTabClickAction2 act)
		{
			int k = 0;
			switch(act)
			{
				case TbTabClickAction2.OpenBlank:
					k = 1; break;
				case TbTabClickAction2.ShowPageListMenu:
					k = 2; break;
				case TbTabClickAction2.ShowRecentClosedMenu:
					k = 3; break;
				default:
					k = 0; break;
			}
			return k;
		}
		private TbTabClickAction2 conv_TbTabAction2_index(int index)
		{
			TbTabClickAction2 act = TbTabClickAction2.None;
			switch(index)
			{
				case 1:
					act = TbTabClickAction2.OpenBlank;
					break;
				case 2:
					act = TbTabClickAction2.ShowPageListMenu;
					break;
				case 3:
					act = TbTabClickAction2.ShowRecentClosedMenu;
					break;
				default:
					act = TbTabClickAction2.None;
					break;
			}
			return act;
		}

		#endregion

		#region Handler

		/// <summary>
		/// TextBox̕񂪁ASingleLine̐K\NXɕϊł邩Validate
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtbox_regexsl_Validating(object sender, CancelEventArgs e)
		{
			try
			{
				string txt = (sender as TextBox).Text;
				if(txt.Contains("\n"))
				{
					MessageBox.Show("s܂ރp^[w肷邱Ƃ͏o܂");
					e.Cancel = true;
				}
				Regex r = new Regex(txt, RegexOptions.Singleline);
				r = null;
			}
			catch
			{
				e.Cancel = true;
				MessageBox.Show("K\Ɏw肳ꂽ񂪕sł");
			}
		}

		/// <summary>
		/// TextBox̕񂪁AInt32ɕϊł邩Validate
		/// TagvpeBint[2]Ă΁A[0]=min`[1]=max̊Ԃɒl܂Ă邩Ƀ`FbN
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtbox_intval_Validating(object sender, CancelEventArgs e)
		{
			int vl = -1;
			TextBox txtb = sender as TextBox;
			if(Int32.TryParse(txtb.Text, out vl))
			{
				int[] minmax = txtb.Tag as int[];
				if(minmax != null
					&& (vl < minmax[0] || minmax[1] < vl))
				{
					e.Cancel = true;
					MessageBox.Show("lsł");
				}
			}
			else
			{
				e.Cancel = true;
				MessageBox.Show("lsł");
			}
			txtb = null;
		}
		/// <summary>
		/// OuEU̎Qƃ{^̃nh
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void man_btn_browserref_Click(object sender, EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			ofd.Multiselect = false;
			ofd.Filter = "exet@C (*.exe)|*.exe";
			ofd.FilterIndex = 0;
			ofd.CheckFileExists = true;
			ofd.FileOk += new CancelEventHandler(ofd_FileOk);
			if(ofd.ShowDialog() == DialogResult.OK)
			{
				this.man_txt_browserpath.Text = ofd.FileName;
			}
			ofd.Dispose();
			ofd = null;
		}
		/// <summary>
		/// ̃Av̋NpXw肵ꍇAbort
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		void ofd_FileOk(object sender, CancelEventArgs e)
		{
			if(Application.ExecutablePath == (sender as OpenFileDialog).FileName)
			{
				MessageBox.Show("̃t@C͎wł܂");
				e.Cancel = true;
			}
		}

		#endregion

		private void sec_chk_ui_accept_edit_CheckedChanged(object sender, EventArgs e)
		{
			bool frg = this.sec_chk_ui_accept_edit.Checked;
			this.sec_txt_trustzone.Enabled = frg;
			this.sec_txt_dangerzone.Enabled = frg;
		}

		private void dis_chk_edittitle_CheckedChanged(object sender, EventArgs e)
		{
			bool frg = this.dis_chk_edittitle.Checked;
			this.dis_txt_matchhost.Enabled = frg;
			this.dis_txt_titlematch.Enabled = frg;
			this.dis_txt_titlereplace.Enabled = frg;
		}

		private void btnTestTitle_Click(object sender, EventArgs e)
		{
			bool err = false;
			string bef = this.dis_txt_testtitle.Text;
			string aft = "";
			int val = 0;
			Int32.TryParse(this.dis_txt_titlemaxchars.Text, out val);
			System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
			try
			{
				sw.Start();
				aft = Regex.Replace(bef,
					this.dis_txt_titlematch.Text,
					this.dis_txt_titlereplace.Text,
					RegexOptions.Singleline);
				if(val != 0) { aft = aft.Substring(0, val); }
			}
			catch
			{
				err = true;
				aft = "[** K\̃G[ **]";
			}
			sw.Stop();

			MessageBox.Show(
				String.Format(
				"[͂ꂽeLXg]\n{0}\n\n[u]\n{1}",bef, aft),
				"-- K\ɂueXg --",
				MessageBoxButtons.OK, err ? MessageBoxIcon.Error : MessageBoxIcon.None);
		}

		private void tab_chk_wheelontab_CheckedChanged(object sender, EventArgs e)
		{
			this.tab_chk_rotatewheel.Enabled = this.tab_chk_wheelontab.Checked;
		}



	}
}
