using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

using HttpService;

namespace Boon.Forms.Dialog
{
    public partial class CreateFolderDialog : Form
    {
        private string _folderPath = "";
        private TreeView _treeView = null;

        public CreateFolderDialog()
        {
            InitializeComponent();
            this.comboBox1.Focus();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (this.comboBox1.Text.Equals(""))
            {
                return;
            }

            string newFolder = Core.ReplaceInvalidFileNameChars(this.comboBox1.Text);

            if (Directory.Exists(this._folderPath + @"\" + newFolder))
            {
                MessageBox.Show("݂ĂtH_łB");

                return;
            }

            Directory.CreateDirectory(this._folderPath + @"\" + newFolder);
            TreeNode tn = new TreeNode(newFolder);
            tn.ImageIndex = 1;
            tn.SelectedImageIndex = 3;
            tn.Tag = this._folderPath + @"\" + newFolder;

            this._treeView.SelectedNode.Nodes.Add(tn);
            this._treeView.SelectedNode.Expand();

            this.Close();

        }

        public void setFolderData(TreeView treeView, string folderPath)
        {
            this._treeView = treeView;
            this._folderPath = folderPath;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this._folderPath = "";
            this.Close();
        }

        private void comboBox1_TextChanged(object sender, EventArgs e)
        {
            this.button1.Enabled = (!this.comboBox1.Text.Equals(""));
        }
    }
}